/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.opensearch.DecoderDescriptor;
import io.trino.plugin.opensearch.client.IndexMetadata;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public record OpenSearchColumnHandle(List<String> path, Type type, IndexMetadata.Type opensearchType, DecoderDescriptor decoderDescriptor, boolean supportsPredicates) implements ColumnHandle
{
    public OpenSearchColumnHandle {
        path = ImmutableList.copyOf(path);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(opensearchType, "opensearchType is null");
        Objects.requireNonNull(decoderDescriptor, "decoderDescriptor is null");
    }

    @JsonIgnore
    public String name() {
        return Joiner.on((char)'.').join(this.path);
    }

    @Override
    public String toString() {
        return this.name() + "::" + String.valueOf(this.type());
    }
}

