/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.opensearch.OpenSearchColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;

public record OpenSearchTableHandle(Type type, String schema, String index, TupleDomain<ColumnHandle> constraint, Map<String, String> regexes, Optional<String> query, OptionalLong limit, Set<OpenSearchColumnHandle> columns) implements ConnectorTableHandle
{
    public OpenSearchTableHandle(Type type, String schema, String index, Optional<String> query) {
        this(type, schema, index, (TupleDomain<ColumnHandle>)TupleDomain.all(), (Map<String, String>)ImmutableMap.of(), query, OptionalLong.empty(), (Set<OpenSearchColumnHandle>)ImmutableSet.of());
    }

    public OpenSearchTableHandle {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(index, "index is null");
        Objects.requireNonNull(constraint, "constraint is null");
        regexes = ImmutableMap.copyOf(Objects.requireNonNull(regexes, "regexes is null"));
        columns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(limit, "limit is null");
    }

    public OpenSearchTableHandle withColumns(Set<OpenSearchColumnHandle> columns) {
        return new OpenSearchTableHandle(this.type, this.schema, this.index, this.constraint, this.regexes, this.query, this.limit, columns);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.valueOf((Object)this.type) + ":" + this.index);
        StringBuilder attributes = new StringBuilder();
        if (!this.regexes.isEmpty()) {
            attributes.append("regexes=[");
            attributes.append(this.regexes.entrySet().stream().map(regex -> (String)regex.getKey() + ":" + (String)regex.getValue()).collect(Collectors.joining(", ")));
            attributes.append("]");
        }
        this.limit.ifPresent(value -> attributes.append("limit=" + value));
        this.query.ifPresent(value -> attributes.append("query" + value));
        if (attributes.length() > 0) {
            builder.append("(");
            builder.append((CharSequence)attributes);
            builder.append(")");
        }
        return builder.toString();
    }

    public static enum Type {
        SCAN,
        QUERY;

    }
}

