/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.opensearch.OpenSearchTableHandle;
import io.trino.plugin.opensearch.client.OpenSearchClient;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class PassthroughQueryPageSource
implements ConnectorPageSource {
    private final long readTimeNanos;
    private final String result;
    private boolean done;

    public PassthroughQueryPageSource(OpenSearchClient client, OpenSearchTableHandle table) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(table, "table is null");
        long start = System.nanoTime();
        this.result = client.executeQuery(table.index(), table.query().get());
        this.readTimeNanos = System.nanoTime() - start;
    }

    public long getCompletedBytes() {
        return this.result.length();
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.done;
    }

    public Page getNextPage() {
        if (this.done) {
            return null;
        }
        this.done = true;
        PageBuilder page = new PageBuilder(1, (List)ImmutableList.of((Object)VarcharType.VARCHAR));
        page.declarePosition();
        BlockBuilder column = page.getBlockBuilder(0);
        VarcharType.VARCHAR.writeSlice(column, Slices.utf8Slice((String)this.result));
        return page.build();
    }

    public long getMemoryUsage() {
        return 0L;
    }

    public void close() throws IOException {
    }
}

