/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class SearchShardsResponse {
    private final List<List<Shard>> shardGroups;

    @JsonCreator
    public SearchShardsResponse(@JsonProperty(value="shards") List<List<Shard>> shardGroups) {
        Objects.requireNonNull(shardGroups, "shardGroups is null");
        this.shardGroups = ImmutableList.copyOf(shardGroups);
    }

    public List<List<Shard>> getShardGroups() {
        return this.shardGroups;
    }

    public static class Shard {
        private final String index;
        private final boolean primary;
        private final String node;
        private final int shard;

        @JsonCreator
        public Shard(@JsonProperty(value="index") String index, @JsonProperty(value="shard") int shard, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="node") String node) {
            this.index = Objects.requireNonNull(index, "index is null");
            this.shard = shard;
            this.primary = primary;
            this.node = Objects.requireNonNull(node, "node is null");
        }

        public String getIndex() {
            return this.index;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public String getNode() {
            return this.node;
        }

        public int getShard() {
            return this.shard;
        }

        public String toString() {
            return this.index + ":" + this.shard + "@" + this.node + (this.primary ? "[primary]" : "[replica]");
        }
    }
}

