/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch.decoders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.opensearch.DecoderDescriptor;
import io.trino.plugin.opensearch.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BooleanType;
import java.util.Objects;
import java.util.function.Supplier;
import org.opensearch.search.SearchHit;

public class BooleanDecoder
implements Decoder {
    private final String path;

    public BooleanDecoder(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
            return;
        } else if (value instanceof Boolean) {
            BooleanType.BOOLEAN.writeBoolean(output, ((Boolean)value).booleanValue());
            return;
        } else {
            if (!(value instanceof String)) throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected a boolean value for field %s of type BOOLEAN: %s [%s]", this.path, value, value.getClass().getSimpleName()));
            if (value.equals("true")) {
                BooleanType.BOOLEAN.writeBoolean(output, true);
                return;
            } else {
                if (!value.equals("false") && !value.equals("")) throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Cannot parse value for field '%s' as BOOLEAN: %s", this.path, value));
                BooleanType.BOOLEAN.writeBoolean(output, false);
            }
        }
    }

    public static class Descriptor
    implements DecoderDescriptor {
        private final String path;

        @JsonCreator
        public Descriptor(String path) {
            this.path = path;
        }

        @JsonProperty
        public String getPath() {
            return this.path;
        }

        @Override
        public Decoder createDecoder() {
            return new BooleanDecoder(this.path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Descriptor that = (Descriptor)o;
            return Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }
}

