/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch.decoders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import io.trino.plugin.opensearch.DecoderDescriptor;
import io.trino.plugin.opensearch.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import java.util.function.Supplier;
import org.opensearch.search.SearchHit;

public class RawJsonDecoder
implements Decoder {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private final String path;

    public RawJsonDecoder(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
        } else {
            try {
                String rawJsonValue = OBJECT_MAPPER.writeValueAsString(value);
                VarcharType.VARCHAR.writeSlice(output, Slices.utf8Slice((String)rawJsonValue));
            }
            catch (JsonProcessingException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected valid json for field '%s' marked to be rendered as JSON: %s [%s]", this.path, value, value.getClass().getSimpleName()), (Throwable)e);
            }
        }
    }

    public static class Descriptor
    implements DecoderDescriptor {
        private final String path;

        @JsonCreator
        public Descriptor(String path) {
            this.path = path;
        }

        @JsonProperty
        public String getPath() {
            return this.path;
        }

        @Override
        public Decoder createDecoder() {
            return new RawJsonDecoder(this.path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Descriptor that = (Descriptor)o;
            return Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }
}

