/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorMetadata;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.HiveTransactionManager;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class HiveConnector
implements Connector {
    private final Injector injector;
    private final LifeCycleManager lifeCycleManager;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final ConnectorPageSinkProvider pageSinkProvider;
    private final ConnectorNodePartitioningProvider nodePartitioningProvider;
    private final Set<Procedure> procedures;
    private final Set<TableProcedureMetadata> tableProcedures;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final List<PropertyMetadata<?>> schemaProperties;
    private final List<PropertyMetadata<?>> tableProperties;
    private final List<PropertyMetadata<?>> viewProperties;
    private final List<PropertyMetadata<?>> columnProperties;
    private final List<PropertyMetadata<?>> analyzeProperties;
    private final Optional<ConnectorAccessControl> accessControl;
    private final ClassLoader classLoader;
    private final HiveTransactionManager transactionManager;
    private final boolean singleStatementWritesOnly;

    public HiveConnector(Injector injector, LifeCycleManager lifeCycleManager, HiveTransactionManager transactionManager, ConnectorSplitManager splitManager, ConnectorPageSourceProvider pageSourceProvider, ConnectorPageSinkProvider pageSinkProvider, ConnectorNodePartitioningProvider nodePartitioningProvider, Set<Procedure> procedures, Set<TableProcedureMetadata> tableProcedures, Set<SessionPropertiesProvider> sessionPropertiesProviders, List<PropertyMetadata<?>> schemaProperties, List<PropertyMetadata<?>> tableProperties, List<PropertyMetadata<?>> viewProperties, List<PropertyMetadata<?>> columnProperties, List<PropertyMetadata<?>> analyzeProperties, Optional<ConnectorAccessControl> accessControl, boolean singleStatementWritesOnly, ClassLoader classLoader) {
        this.injector = Objects.requireNonNull(injector, "injector is null");
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
        this.tableProcedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(tableProcedures, "tableProcedures is null"));
        this.sessionProperties = (List)sessionPropertiesProviders.stream().flatMap(sessionPropertiesProvider -> sessionPropertiesProvider.getSessionProperties().stream()).collect(ImmutableList.toImmutableList());
        this.schemaProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(schemaProperties, "schemaProperties is null"));
        this.tableProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableProperties, "tableProperties is null"));
        this.viewProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(viewProperties, "viewProperties is null"));
        this.columnProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnProperties, "columnProperties is null"));
        this.analyzeProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(analyzeProperties, "analyzeProperties is null"));
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.singleStatementWritesOnly = singleStatementWritesOnly;
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
        TransactionalMetadata metadata = this.transactionManager.get(transaction, session.getIdentity());
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return new ClassLoaderSafeConnectorMetadata((ConnectorMetadata)metadata, this.classLoader);
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<PropertyMetadata<?>> getSchemaProperties() {
        return this.schemaProperties;
    }

    public List<PropertyMetadata<?>> getAnalyzeProperties() {
        return this.analyzeProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public List<PropertyMetadata<?>> getViewProperties() {
        return this.viewProperties;
    }

    public List<PropertyMetadata<?>> getColumnProperties() {
        return this.columnProperties;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl.orElseThrow(UnsupportedOperationException::new);
    }

    public boolean isSingleStatementWritesOnly() {
        return this.singleStatementWritesOnly;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (IsolationLevel)isolationLevel);
        HiveTransactionHandle transaction = new HiveTransactionHandle(autoCommit);
        this.transactionManager.begin(transaction);
        return transaction;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        this.transactionManager.commit(transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        this.transactionManager.rollback(transaction);
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }

    public Set<TableProcedureMetadata> getTableProcedures() {
        return this.tableProcedures;
    }

    public Injector getInjector() {
        return this.injector;
    }
}

