/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

public class HivePartitioningHandle
implements ConnectorPartitioningHandle {
    private final HiveBucketing.BucketingVersion bucketingVersion;
    private final int bucketCount;
    private final List<HiveType> hiveTypes;
    private final boolean usePartitionedBucketing;

    @JsonCreator
    public HivePartitioningHandle(@JsonProperty(value="bucketingVersion") HiveBucketing.BucketingVersion bucketingVersion, @JsonProperty(value="bucketCount") int bucketCount, @JsonProperty(value="hiveBucketTypes") List<HiveType> hiveTypes, @JsonProperty(value="usePartitionedBucketing") boolean usePartitionedBucketing) {
        this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
        this.bucketCount = bucketCount;
        Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (Object)"bucketCount must be greater than zero");
        this.hiveTypes = Objects.requireNonNull(hiveTypes, "hiveTypes is null");
        this.usePartitionedBucketing = usePartitionedBucketing;
    }

    @JsonProperty
    public HiveBucketing.BucketingVersion getBucketingVersion() {
        return this.bucketingVersion;
    }

    @JsonProperty
    public int getBucketCount() {
        return this.bucketCount;
    }

    @JsonProperty
    public List<HiveType> getHiveTypes() {
        return this.hiveTypes;
    }

    @JsonProperty
    public boolean isUsePartitionedBucketing() {
        return this.usePartitionedBucketing;
    }

    public long getCacheKeyHint() {
        Hasher hasher = Hashing.goodFastHash((int)64).newHasher();
        hasher.putInt(this.bucketingVersion.getVersion());
        hasher.putInt(this.bucketCount);
        for (HiveType hiveType : this.hiveTypes) {
            hasher.putString((CharSequence)hiveType.toString(), StandardCharsets.UTF_8);
        }
        return hasher.hash().asLong();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("buckets", this.bucketCount).add("hiveTypes", this.hiveTypes).add("version", this.bucketingVersion.getVersion()).add("usePartitionedBucketing", (Object)(this.usePartitionedBucketing ? Boolean.valueOf(true) : null)).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePartitioningHandle that = (HivePartitioningHandle)o;
        return this.bucketingVersion == that.bucketingVersion && this.bucketCount == that.bucketCount && this.usePartitionedBucketing == that.usePartitionedBucketing && Objects.equals(this.hiveTypes, that.hiveTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bucketingVersion, this.bucketCount, this.hiveTypes, this.usePartitionedBucketing});
    }
}

