/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.trino.metastore.Table;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveToTrinoTranslator;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.util.HiveTypeUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.type.TypeId;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class LegacyHiveViewReader
implements ViewReaderUtil.ViewReader {
    private final boolean hiveViewsRunAsInvoker;

    public LegacyHiveViewReader(boolean hiveViewsRunAsInvoker) {
        this.hiveViewsRunAsInvoker = hiveViewsRunAsInvoker;
    }

    @Override
    public ConnectorViewDefinition decodeViewData(String viewData, Table table, CatalogName catalogName) {
        String viewText = (String)table.getViewExpandedText().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "No view expanded text: " + String.valueOf(table.getSchemaTableName())));
        return new ConnectorViewDefinition(HiveToTrinoTranslator.translateHiveViewToTrino(viewText), Optional.of(catalogName.toString()), Optional.ofNullable(table.getDatabaseName()), (List)Stream.concat(table.getDataColumns().stream(), table.getPartitionColumns().stream()).map(column -> new ConnectorViewDefinition.ViewColumn(column.getName(), TypeId.of((String)HiveTypeUtil.getTypeSignature(column.getType()).toString()), column.getComment())).collect(ImmutableList.toImmutableList()), Optional.ofNullable((String)table.getParameters().get("comment")), Optional.empty(), this.hiveViewsRunAsInvoker, (List)ImmutableList.of());
    }
}

