/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import io.trino.filesystem.Location;
import io.trino.metastore.HiveType;
import io.trino.orc.OrcWriter;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveWriterFactory;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.PartitionUpdateAndMergeResults;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidSchema;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.orc.OrcFileWriter;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.plugin.hive.util.AcidTables;
import io.trino.plugin.hive.util.HiveTypeUtil;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.MergePage;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MergeFileWriter
implements FileWriter {
    private static final Pattern BUCKET_PATH_MATCHER = Pattern.compile("(?s)(?<rootDir>.*)/(?<dirStart>delta_\\d+_\\d+)_(?<statementId>\\d+)/(?<filenameBase>bucket_(?<bucketNumber>\\d+))(?<attemptId>_\\d+)?$");
    private static final Pattern BASE_PATH_MATCHER = Pattern.compile("(?s)(?<rootDir>.*)/(?<dirStart>base_-?\\d+(_v\\d+)?)/(?<filenameBase>bucket_(?<bucketNumber>\\d+))(?<attemptId>_\\d+)?$");
    private static final Block DELETE_OPERATION_BLOCK = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcWriter.OrcOperation.DELETE.getOperationNumber());
    private static final Block INSERT_OPERATION_BLOCK = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcWriter.OrcOperation.INSERT.getOperationNumber());
    private final AcidTransaction transaction;
    private final OptionalInt bucketNumber;
    private final Block bucketValueBlock;
    private final ConnectorSession session;
    private final Block hiveRowTypeNullsBlock;
    private final Location deltaDirectory;
    private final Location deleteDeltaDirectory;
    private final List<HiveColumnHandle> inputColumns;
    private final HiveWriterFactory.RowIdSortingFileWriterMaker sortingFileWriterMaker;
    private final OrcFileWriterFactory orcFileWriterFactory;
    private final HiveCompressionCodec compressionCodec;
    private final Map<String, String> hiveAcidSchema;
    private final String bucketFilename;
    private Optional<FileWriter> deleteFileWriter = Optional.empty();
    private Optional<FileWriter> insertFileWriter = Optional.empty();
    private int deleteRowCount;
    private int insertRowCount;

    public MergeFileWriter(AcidTransaction transaction, int statementId, OptionalInt bucketNumber, HiveWriterFactory.RowIdSortingFileWriterMaker sortingFileWriterMaker, String bucketPath, OrcFileWriterFactory orcFileWriterFactory, HiveCompressionCodec compressionCodec, List<HiveColumnHandle> inputColumns, ConnectorSession session, TypeManager typeManager, HiveType hiveRowType) {
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.sortingFileWriterMaker = Objects.requireNonNull(sortingFileWriterMaker, "sortingFileWriterMaker is null");
        this.bucketValueBlock = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcFileWriter.computeBucketValue(bucketNumber.orElse(0), statementId));
        this.orcFileWriterFactory = Objects.requireNonNull(orcFileWriterFactory, "orcFileWriterFactory is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
        this.session = Objects.requireNonNull(session, "session is null");
        Preconditions.checkArgument((boolean)transaction.isTransactional(), (String)"Not in a transaction: %s", (Object)transaction);
        this.hiveAcidSchema = AcidSchema.createAcidSchema(hiveRowType);
        this.hiveRowTypeNullsBlock = Utils.nativeValueToBlock((Type)typeManager.getType(HiveTypeUtil.getTypeSignature(hiveRowType)), null);
        Matcher matcher = BASE_PATH_MATCHER.matcher(bucketPath);
        if (!matcher.matches()) {
            matcher = BUCKET_PATH_MATCHER.matcher(bucketPath);
            Preconditions.checkArgument((boolean)matcher.matches(), (String)"bucketPath doesn't have the required format: %s", (Object)bucketPath);
        }
        this.bucketFilename = matcher.group("filenameBase");
        long writeId = transaction.getWriteId();
        this.deltaDirectory = Location.of((String)matcher.group("rootDir")).appendPath(AcidTables.deltaSubdir(writeId, statementId));
        this.deleteDeltaDirectory = Location.of((String)matcher.group("rootDir")).appendPath(AcidTables.deleteDeltaSubdir(writeId, statementId));
        this.inputColumns = Objects.requireNonNull(inputColumns, "inputColumns is null");
    }

    @Override
    public void appendRows(Page page) {
        if (page.getPositionCount() == 0) {
            return;
        }
        MergePage mergePage = MergePage.createDeleteAndInsertPages((Page)page, (int)this.inputColumns.size());
        mergePage.getDeletionsPage().ifPresent(deletePage -> {
            Block acidBlock = deletePage.getBlock(deletePage.getChannelCount() - 1);
            Page orcDeletePage = this.buildDeletePage(acidBlock, this.transaction.getWriteId());
            this.getOrCreateDeleteFileWriter().appendRows(orcDeletePage);
            this.deleteRowCount += deletePage.getPositionCount();
        });
        mergePage.getInsertionsPage().ifPresent(insertPage -> {
            Page orcInsertPage = MergeFileWriter.buildInsertPage(insertPage, this.transaction.getWriteId(), this.inputColumns, this.bucketValueBlock, this.insertRowCount);
            this.getOrCreateInsertFileWriter().appendRows(orcInsertPage);
            this.insertRowCount += insertPage.getPositionCount();
        });
    }

    @VisibleForTesting
    public static Page buildInsertPage(Page insertPage, long writeId, List<HiveColumnHandle> columns, Block bucketValueBlock, int insertRowCount) {
        int positionCount = insertPage.getPositionCount();
        List dataColumns = (List)columns.stream().filter(column -> !column.isPartitionKey() && !column.isHidden()).map(column -> insertPage.getBlock(column.getBaseHiveColumnIndex())).collect(ImmutableList.toImmutableList());
        RowBlock mergedColumnsBlock = RowBlock.fromFieldBlocks((int)positionCount, (Block[])dataColumns.toArray(new Block[0]));
        Block currentTransactionBlock = RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)writeId, (int)positionCount);
        Block[] blockArray = new Block[]{RunLengthEncodedBlock.create((Block)INSERT_OPERATION_BLOCK, (int)positionCount), currentTransactionBlock, RunLengthEncodedBlock.create((Block)bucketValueBlock, (int)positionCount), MergeFileWriter.createRowIdBlock(positionCount, insertRowCount), currentTransactionBlock, mergedColumnsBlock};
        return new Page(blockArray);
    }

    @Override
    public long getWrittenBytes() {
        return this.deleteFileWriter.map(FileWriter::getWrittenBytes).orElse(0L) + this.insertFileWriter.map(FileWriter::getWrittenBytes).orElse(0L);
    }

    @Override
    public long getMemoryUsage() {
        return this.deleteFileWriter.map(FileWriter::getMemoryUsage).orElse(0L) + this.insertFileWriter.map(FileWriter::getMemoryUsage).orElse(0L);
    }

    @Override
    public Closeable commit() {
        Optional<Closeable> deleteRollbackAction = this.deleteFileWriter.map(FileWriter::commit);
        Optional<Closeable> insertRollbackAction = this.insertFileWriter.map(FileWriter::commit);
        return () -> {
            try (Closer closer = Closer.create();){
                insertRollbackAction.ifPresent(arg_0 -> ((Closer)closer).register(arg_0));
                deleteRollbackAction.ifPresent(arg_0 -> ((Closer)closer).register(arg_0));
            }
        };
    }

    @Override
    public void rollback() {
        try (Closer closer = Closer.create();){
            closer.register(() -> this.insertFileWriter.ifPresent(FileWriter::rollback));
            closer.register(() -> this.deleteFileWriter.ifPresent(FileWriter::rollback));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getValidationCpuNanos() {
        return this.deleteFileWriter.map(FileWriter::getValidationCpuNanos).orElse(0L) + this.insertFileWriter.map(FileWriter::getValidationCpuNanos).orElse(0L);
    }

    public PartitionUpdateAndMergeResults getPartitionUpdateAndMergeResults(PartitionUpdate partitionUpdate) {
        return new PartitionUpdateAndMergeResults(partitionUpdate.withRowCount(this.insertRowCount - this.deleteRowCount), this.insertRowCount, this.insertFileWriter.isPresent() ? Optional.of(this.deltaDirectory.toString()) : Optional.empty(), this.deleteRowCount, this.deleteFileWriter.isPresent() ? Optional.of(this.deleteDeltaDirectory.toString()) : Optional.empty());
    }

    private Page buildDeletePage(Block rowIds, long writeId) {
        int positionCount = rowIds.getPositionCount();
        if (rowIds.mayHaveNull()) {
            for (int position = 0; position < positionCount; ++position) {
                Preconditions.checkArgument((!rowIds.isNull(position) ? 1 : 0) != 0, (Object)"The rowIdsRowBlock may not have null rows");
            }
        }
        List fields = RowBlock.getRowFieldsFromBlock((Block)rowIds);
        Block[] blockArray = new Block[]{RunLengthEncodedBlock.create((Block)DELETE_OPERATION_BLOCK, (int)positionCount), (Block)fields.get(0), (Block)fields.get(1), (Block)fields.get(2), RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)writeId, (int)positionCount), RunLengthEncodedBlock.create((Block)this.hiveRowTypeNullsBlock, (int)positionCount)};
        return new Page(blockArray);
    }

    private FileWriter getOrCreateInsertFileWriter() {
        if (this.insertFileWriter.isEmpty()) {
            this.insertFileWriter = this.orcFileWriterFactory.createFileWriter(this.deltaDirectory.appendPath(this.bucketFilename), AcidSchema.ACID_COLUMN_NAMES, HiveStorageFormat.ORC.toStorageFormat(), this.compressionCodec, this.hiveAcidSchema, this.session, this.bucketNumber, this.transaction, true, WriterKind.INSERT);
        }
        return MergeFileWriter.getWriter(this.insertFileWriter);
    }

    private FileWriter getOrCreateDeleteFileWriter() {
        if (this.deleteFileWriter.isEmpty()) {
            Location deletePath = this.deleteDeltaDirectory.appendPath(this.bucketFilename);
            FileWriter writer = MergeFileWriter.getWriter(this.orcFileWriterFactory.createFileWriter(deletePath, AcidSchema.ACID_COLUMN_NAMES, HiveStorageFormat.ORC.toStorageFormat(), this.compressionCodec, this.hiveAcidSchema, this.session, this.bucketNumber, this.transaction, true, WriterKind.DELETE));
            this.deleteFileWriter = Optional.of(this.sortingFileWriterMaker.makeFileWriter(writer, deletePath));
        }
        return MergeFileWriter.getWriter(this.deleteFileWriter);
    }

    private static Block createRowIdBlock(int positionCount, int rowCounter) {
        long[] rowIds = new long[positionCount];
        for (int index = 0; index < positionCount; ++index) {
            rowIds[index] = rowCounter;
            ++rowCounter;
        }
        return new LongArrayBlock(positionCount, Optional.empty(), rowIds);
    }

    private static FileWriter getWriter(Optional<FileWriter> writer) {
        return writer.orElseThrow(() -> new IllegalArgumentException("writer is not present"));
    }
}

