/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.v1;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.glue.AWSGlue;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.model.Table;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkTelemetry;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.base.ClosingBinder;
import io.trino.plugin.hive.AllowHiveTableRename;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.v1.DefaultGlueColumnStatisticsProviderFactory;
import io.trino.plugin.hive.metastore.glue.v1.DefaultGlueMetastoreTableFilterProvider;
import io.trino.plugin.hive.metastore.glue.v1.ForGlueColumnStatisticsRead;
import io.trino.plugin.hive.metastore.glue.v1.ForGlueColumnStatisticsWrite;
import io.trino.plugin.hive.metastore.glue.v1.ForGlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.v1.GlueCatalogIdRequestHandler;
import io.trino.plugin.hive.metastore.glue.v1.GlueColumnStatisticsProviderFactory;
import io.trino.plugin.hive.metastore.glue.v1.GlueCredentialsProvider;
import io.trino.plugin.hive.metastore.glue.v1.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.v1.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.v1.GlueHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.glue.v1.HiveGlueClientProvider;
import io.trino.plugin.hive.metastore.glue.v1.ProxyApiRequestHandler;
import io.trino.plugin.hive.metastore.glue.v1.SkipArchiveRequestHandler;
import java.lang.annotation.Annotation;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Predicate;
import org.weakref.jmx.guice.ExportBinder;

public class GlueMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        GlueHiveMetastoreConfig glueConfig = (GlueHiveMetastoreConfig)this.buildConfigObject(GlueHiveMetastoreConfig.class);
        Multibinder requestHandlers = Multibinder.newSetBinder((Binder)binder, RequestHandler2.class, ForGlueHiveMetastore.class);
        glueConfig.getCatalogId().ifPresent(catalogId -> requestHandlers.addBinding().toInstance((Object)new GlueCatalogIdRequestHandler((String)catalogId)));
        glueConfig.getGlueProxyApiId().ifPresent(glueProxyApiId -> requestHandlers.addBinding().toInstance((Object)new ProxyApiRequestHandler((String)glueProxyApiId)));
        binder.bind(AWSCredentialsProvider.class).toProvider(GlueCredentialsProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get((TypeLiteral)new TypeLiteral<Predicate<Table>>(this){}, ForGlueHiveMetastore.class)).setDefault().toProvider(DefaultGlueMetastoreTableFilterProvider.class).in(Scopes.SINGLETON);
        binder.bind(GlueHiveMetastore.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(HiveMetastoreFactory.class, RawHiveMetastoreFactory.class)).setDefault().to(GlueHiveMetastoreFactory.class).in(Scopes.SINGLETON);
        binder.bind(GlueHiveMetastoreFactory.class).in(Scopes.SINGLETON);
        binder.bind(Key.get(GlueMetastoreStats.class, ForGlueHiveMetastore.class)).toInstance((Object)new GlueMetastoreStats());
        binder.bind(AWSGlueAsync.class).toProvider(HiveGlueClientProvider.class).in(Scopes.SINGLETON);
        ClosingBinder.closingBinder((Binder)binder).registerResource(AWSGlueAsync.class, AWSGlue::shutdown);
        ExportBinder.newExporter((Binder)binder).export(GlueHiveMetastore.class).withGeneratedName();
        binder.bind(Key.get(Boolean.TYPE, AllowHiveTableRename.class)).toInstance((Object)false);
        OptionalBinder.newOptionalBinder((Binder)binder, GlueColumnStatisticsProviderFactory.class).setDefault().to(DefaultGlueColumnStatisticsProviderFactory.class).in(Scopes.SINGLETON);
        this.createExecutor(ForGlueHiveMetastore.class, "hive-glue-partitions-%s", GlueHiveMetastoreConfig::getGetPartitionThreads);
        this.createExecutor(ForGlueColumnStatisticsRead.class, "hive-glue-statistics-read-%s", GlueHiveMetastoreConfig::getReadStatisticsThreads);
        this.createExecutor(ForGlueColumnStatisticsWrite.class, "hive-glue-statistics-write-%s", GlueHiveMetastoreConfig::getWriteStatisticsThreads);
    }

    @ProvidesIntoSet
    @Singleton
    @ForGlueHiveMetastore
    public RequestHandler2 createSkipArchiveRequestHandler(GlueHiveMetastoreConfig config) {
        if (!config.isSkipArchive()) {
            return new RequestHandler2(this){};
        }
        return new SkipArchiveRequestHandler();
    }

    @ProvidesIntoSet
    @Singleton
    @ForGlueHiveMetastore
    public RequestHandler2 createTelemetryRequestHandler(OpenTelemetry openTelemetry) {
        return AwsSdkTelemetry.builder((OpenTelemetry)openTelemetry).setCaptureExperimentalSpanAttributes(true).build().newRequestHandler();
    }

    private void createExecutor(Class<? extends Annotation> annotationClass, String nameTemplate, Function<GlueHiveMetastoreConfig, Integer> threads) {
        this.install(ConditionalModule.conditionalModule(GlueHiveMetastoreConfig.class, config -> (Integer)threads.apply((GlueHiveMetastoreConfig)config) > 1, binder -> {
            binder.bind(Key.get(ExecutorService.class, (Class)annotationClass)).toInstance((Object)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)nameTemplate)));
            binder.bind(Key.get(Executor.class, (Class)annotationClass)).toProvider((Provider)new BoundedExecutorProvider(annotationClass, threads)).in(Scopes.SINGLETON);
            ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, (Class)annotationClass));
        }, binder -> binder.bind(Key.get(Executor.class, (Class)annotationClass)).toInstance((Object)MoreExecutors.directExecutor())));
    }

    private static class BoundedExecutorProvider
    implements Provider<BoundedExecutor> {
        private final Class<? extends Annotation> annotationClass;
        private final Function<GlueHiveMetastoreConfig, Integer> threads;
        private Injector injector;

        public BoundedExecutorProvider(Class<? extends Annotation> annotationClass, Function<GlueHiveMetastoreConfig, Integer> threads) {
            this.annotationClass = annotationClass;
            this.threads = threads;
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public BoundedExecutor get() {
            ExecutorService executor = (ExecutorService)this.injector.getInstance(Key.get(ExecutorService.class, this.annotationClass));
            int threads = this.threads.apply((GlueHiveMetastoreConfig)this.injector.getInstance(GlueHiveMetastoreConfig.class));
            Preconditions.checkArgument((threads > 0 ? 1 : 0) != 0, (String)"Invalid number of threads: %s", (int)threads);
            return new BoundedExecutor((Executor)executor, threads);
        }
    }
}

