/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.metastore.thrift.IdentityAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.RetryDriver;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveWriteStatisticsExecutor;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreStats;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class ThriftHttpMetastoreFactory
implements ThriftMetastoreFactory {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final IdentityAwareMetastoreClientFactory metastoreClientFactory;
    private final ExecutorService writeStatisticsExecutor;
    private final ThriftMetastoreStats stats = new ThriftMetastoreStats();

    @Inject
    public ThriftHttpMetastoreFactory(TrinoFileSystemFactory fileSystemFactory, IdentityAwareMetastoreClientFactory metastoreClientFactory, @ThriftHiveWriteStatisticsExecutor ExecutorService writeStatisticsExecutor) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.metastoreClientFactory = Objects.requireNonNull(metastoreClientFactory, "metastoreClientFactory is null");
        this.writeStatisticsExecutor = Objects.requireNonNull(writeStatisticsExecutor, "writeStatisticsExecutor is null");
    }

    @Override
    public boolean isImpersonationEnabled() {
        return false;
    }

    @Override
    public ThriftMetastore createMetastore(Optional<ConnectorIdentity> identity) {
        return new ThriftHiveMetastore(identity, this.fileSystemFactory, this.metastoreClientFactory, 2.0, RetryDriver.DEFAULT_MIN_BACKOFF_DELAY, RetryDriver.DEFAULT_MAX_BACKOFF_DELAY, RetryDriver.DEFAULT_MAX_RETRY_TIME, new Duration(10.0, TimeUnit.MINUTES), 10, false, false, false, this.stats, this.writeStatisticsExecutor);
    }

    @Managed
    @Flatten
    public ThriftMetastoreStats getStats() {
        return this.stats;
    }
}

