/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.ADLStoreClient;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.ADLStoreOptions;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.DirectoryEntry;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.IfExists;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.LatencyTracker;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.UserGroupRepresentation;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2.ClientCredsTokenProvider;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2.DeviceCodeTokenProvider;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2.MsiTokenProvider;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.oauth2.RefreshTokenBasedTokenProvider;
import io.trino.hadoop.$internal.org.apache.commons.lang3.StringUtils;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.AdlConfKeys;
import org.apache.hadoop.fs.adl.AdlFileStatus;
import org.apache.hadoop.fs.adl.AdlFsInputStream;
import org.apache.hadoop.fs.adl.AdlFsOutputStream;
import org.apache.hadoop.fs.adl.SdkTokenProviderAdapter;
import org.apache.hadoop.fs.adl.TokenProviderType;
import org.apache.hadoop.fs.adl.oauth2.AzureADTokenProvider;
import org.apache.hadoop.fs.impl.PathCapabilitiesSupport;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AdlFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AdlFileSystem.class);
    public static final String SCHEME = "adl";
    static final int DEFAULT_PORT = 443;
    private URI uri;
    private String userName;
    private boolean overrideOwner;
    private ADLStoreClient adlClient;
    private Path workingDirectory;
    private boolean aclBitStatus;
    private UserGroupRepresentation oidOrUpn;
    private AccessTokenProvider tokenProvider;
    private AzureADTokenProvider azureTokenProvider;

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public int getDefaultPort() {
        return 443;
    }

    @Override
    public boolean supportsSymlinks() {
        return false;
    }

    @Override
    public void initialize(URI storeUri, Configuration originalConf) throws IOException {
        boolean enableUPN;
        String hostname = storeUri.getHost();
        String accountName = AdlFileSystem.getAccountNameFromFQDN(hostname);
        Configuration conf = AdlFileSystem.propagateAccountOptions(originalConf, accountName);
        super.initialize(storeUri, conf);
        this.setConf(conf);
        this.uri = URI.create(storeUri.getScheme() + "://" + storeUri.getAuthority());
        try {
            this.userName = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            this.userName = "hadoop";
            LOG.warn("Got exception when getting Hadoop user name. Set the user name to '" + this.userName + "'.", e);
        }
        this.setWorkingDirectory(this.getHomeDirectory());
        this.overrideOwner = this.getConf().getBoolean("adl.debug.override.localuserasfileowner", false);
        this.aclBitStatus = conf.getBoolean("adl.feature.support.acl.bit", true);
        String accountFQDN = null;
        String mountPoint = null;
        if (!hostname.contains(".") && !hostname.equalsIgnoreCase("localhost")) {
            String hostNameProperty = "dfs.adls." + hostname + ".hostname";
            String mountPointProperty = "dfs.adls." + hostname + ".mountpoint";
            accountFQDN = AdlFileSystem.getNonEmptyVal(conf, hostNameProperty);
            mountPoint = AdlFileSystem.getNonEmptyVal(conf, mountPointProperty);
        } else {
            accountFQDN = hostname;
        }
        if (storeUri.getPort() > 0) {
            accountFQDN = accountFQDN + ":" + storeUri.getPort();
        }
        this.adlClient = ADLStoreClient.createClient(accountFQDN, this.getAccessTokenProvider(conf));
        ADLStoreOptions options = new ADLStoreOptions();
        options.enableThrowingRemoteExceptions();
        if (this.getTransportScheme().equalsIgnoreCase("http")) {
            options.setInsecureTransport();
        }
        if (mountPoint != null) {
            options.setFilePathPrefix(mountPoint);
        }
        String clusterName = conf.get("adl.events.tracking.clustername", "UNKNOWN");
        String clusterType = conf.get("adl.events.tracking.clustertype", "UNKNOWN");
        String clientVersion = "hadoop-azure-datalake-" + (StringUtils.isEmpty(VersionInfo.getVersion().trim()) ? "2.0.0-SNAPSHOT".trim() : VersionInfo.getVersion().trim());
        options.setUserAgentSuffix(clientVersion + "/" + VersionInfo.getVersion().trim() + "/" + clusterName + "/" + clusterType);
        int timeout = conf.getInt("adl.http.timeout", -1);
        if (timeout > 0) {
            options.setDefaultTimeout(timeout);
        } else {
            LOG.info("No valid ADL SDK timeout configured: using SDK default.");
        }
        String sslChannelMode = conf.get("adl.ssl.channel.mode", "Default");
        options.setSSLChannelMode(sslChannelMode);
        this.adlClient.setOptions(options);
        boolean trackLatency = conf.getBoolean("adl.enable.client.latency.tracker", true);
        if (!trackLatency) {
            LatencyTracker.disable();
        }
        this.oidOrUpn = (enableUPN = conf.getBoolean("adl.feature.ownerandgroup.enableupn", false)) ? UserGroupRepresentation.UPN : UserGroupRepresentation.OID;
    }

    protected synchronized AzureADTokenProvider getCustomAccessTokenProvider(Configuration conf) throws IOException {
        String className = AdlFileSystem.getNonEmptyVal(conf, "fs.adl.oauth2.access.token.provider");
        Class<AzureADTokenProvider> azureADTokenProviderClass = conf.getClass("fs.adl.oauth2.access.token.provider", null, AzureADTokenProvider.class);
        if (azureADTokenProviderClass == null) {
            throw new IllegalArgumentException("Configuration  " + className + " not defined/accessible.");
        }
        this.azureTokenProvider = ReflectionUtils.newInstance(azureADTokenProviderClass, conf);
        if (this.azureTokenProvider == null) {
            throw new IllegalArgumentException("Failed to initialize " + className);
        }
        this.azureTokenProvider.initialize(conf);
        return this.azureTokenProvider;
    }

    private AccessTokenProvider getAccessTokenProvider(Configuration config) throws IOException {
        Configuration conf = ProviderUtils.excludeIncompatibleCredentialProviders(config, AdlFileSystem.class);
        TokenProviderType type = conf.getEnum("fs.adl.oauth2.access.token.provider.type", AdlConfKeys.AZURE_AD_TOKEN_PROVIDER_TYPE_DEFAULT);
        switch (type) {
            case RefreshToken: {
                this.tokenProvider = this.getConfRefreshTokenBasedTokenProvider(conf);
                break;
            }
            case ClientCredential: {
                this.tokenProvider = this.getConfCredentialBasedTokenProvider(conf);
                break;
            }
            case MSI: {
                this.tokenProvider = this.getMsiBasedTokenProvider(conf);
                break;
            }
            case DeviceCode: {
                this.tokenProvider = this.getDeviceCodeTokenProvider(conf);
                break;
            }
            default: {
                AzureADTokenProvider azureADTokenProvider = this.getCustomAccessTokenProvider(conf);
                this.tokenProvider = new SdkTokenProviderAdapter(azureADTokenProvider);
            }
        }
        return this.tokenProvider;
    }

    private AccessTokenProvider getConfCredentialBasedTokenProvider(Configuration conf) throws IOException {
        String clientId = AdlFileSystem.getPasswordString(conf, "fs.adl.oauth2.client.id");
        String refreshUrl = AdlFileSystem.getPasswordString(conf, "fs.adl.oauth2.refresh.url");
        String clientSecret = AdlFileSystem.getPasswordString(conf, "fs.adl.oauth2.credential");
        return new ClientCredsTokenProvider(refreshUrl, clientId, clientSecret);
    }

    private AccessTokenProvider getConfRefreshTokenBasedTokenProvider(Configuration conf) throws IOException {
        String clientId = AdlFileSystem.getPasswordString(conf, "fs.adl.oauth2.client.id");
        String refreshToken = AdlFileSystem.getPasswordString(conf, "fs.adl.oauth2.refresh.token");
        return new RefreshTokenBasedTokenProvider(clientId, refreshToken);
    }

    private AccessTokenProvider getMsiBasedTokenProvider(Configuration conf) throws IOException {
        return new MsiTokenProvider(conf.getInt("fs.adl.oauth2.msi.port", -1));
    }

    private AccessTokenProvider getDeviceCodeTokenProvider(Configuration conf) throws IOException {
        String clientAppId = AdlFileSystem.getNonEmptyVal(conf, "fs.adl.oauth2.devicecode.clientapp.id");
        return new DeviceCodeTokenProvider(clientAppId);
    }

    @VisibleForTesting
    AccessTokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    @VisibleForTesting
    AzureADTokenProvider getAzureTokenProvider() {
        return this.azureTokenProvider;
    }

    @VisibleForTesting
    public ADLStoreClient getAdlClient() {
        return this.adlClient;
    }

    @Override
    public Path getHomeDirectory() {
        return this.makeQualified(new Path("/user/" + this.userName));
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        IfExists overwriteRule = overwrite ? IfExists.OVERWRITE : IfExists.FAIL;
        return new FSDataOutputStream(new AdlFsOutputStream(this.adlClient.createFile(this.toRelativeFilePath(f), overwriteRule, Integer.toOctalString(this.applyUMask(permission).toShort()), true), this.getConf()), this.statistics);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        IfExists overwriteRule = IfExists.FAIL;
        for (CreateFlag flag : flags) {
            if (flag != CreateFlag.OVERWRITE) continue;
            overwriteRule = IfExists.OVERWRITE;
            break;
        }
        return new FSDataOutputStream(new AdlFsOutputStream(this.adlClient.createFile(this.toRelativeFilePath(f), overwriteRule, Integer.toOctalString(this.applyUMask(permission).toShort()), false), this.getConf()), this.statistics);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        return new FSDataOutputStream(new AdlFsOutputStream(this.adlClient.getAppendStream(this.toRelativeFilePath(f)), this.getConf()), this.statistics);
    }

    @Override
    public boolean setReplication(Path p, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        return true;
    }

    @Override
    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        this.statistics.incrementReadOps(1);
        return new FSDataInputStream(new AdlFsInputStream(this.adlClient.getReadStream(this.toRelativeFilePath(f)), this.statistics, this.getConf()));
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        DirectoryEntry entry = this.adlClient.getDirectoryEntry(this.toRelativeFilePath(f), this.oidOrUpn);
        return this.toFileStatus(entry, f);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        List<DirectoryEntry> entries = this.adlClient.enumerateDirectory(this.toRelativeFilePath(f), this.oidOrUpn);
        return this.toFileStatuses(entries, f);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        if (this.toRelativeFilePath(src).equals("/")) {
            return false;
        }
        return this.adlClient.rename(this.toRelativeFilePath(src), this.toRelativeFilePath(dst));
    }

    @Override
    @Deprecated
    public void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        this.statistics.incrementWriteOps(1);
        boolean overwrite = false;
        for (Options.Rename renameOption : options) {
            if (renameOption != Options.Rename.OVERWRITE) continue;
            overwrite = true;
            break;
        }
        this.adlClient.rename(this.toRelativeFilePath(src), this.toRelativeFilePath(dst), overwrite);
    }

    @Override
    public void concat(Path trg, Path[] srcs) throws IOException {
        this.statistics.incrementWriteOps(1);
        ArrayList<String> sourcesList = new ArrayList<String>();
        for (Path entry : srcs) {
            sourcesList.add(this.toRelativeFilePath(entry));
        }
        this.adlClient.concatenateFiles(this.toRelativeFilePath(trg), sourcesList);
    }

    @Override
    public boolean delete(Path path, boolean recursive) throws IOException {
        this.statistics.incrementWriteOps(1);
        String relativePath = this.toRelativeFilePath(path);
        if (relativePath.equals("/")) {
            if (!recursive && this.adlClient.enumerateDirectory(this.toRelativeFilePath(path), 1).size() > 0) {
                throw new IOException("Delete on root is not supported.");
            }
            return false;
        }
        return recursive ? this.adlClient.deleteRecursive(relativePath) : this.adlClient.delete(relativePath);
    }

    @Override
    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.adlClient.createDirectory(this.toRelativeFilePath(path), Integer.toOctalString(this.applyUMask(permission).toShort()));
    }

    private FileStatus[] toFileStatuses(List<DirectoryEntry> entries, Path parent) {
        FileStatus[] fileStatuses = new FileStatus[entries.size()];
        int index = 0;
        for (DirectoryEntry entry : entries) {
            FileStatus status = this.toFileStatus(entry, parent);
            if (entry.name != null && entry.name != "") {
                status.setPath(new Path(parent.makeQualified(this.uri, this.workingDirectory), entry.name));
            }
            fileStatuses[index++] = status;
        }
        return fileStatuses;
    }

    private FsPermission applyUMask(FsPermission permission) {
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        return permission.applyUMask(FsPermission.getUMask(this.getConf()));
    }

    private FileStatus toFileStatus(DirectoryEntry entry, Path f) {
        boolean aclBit;
        Path p = this.makeQualified(f);
        boolean bl = aclBit = this.aclBitStatus ? entry.aclBit : false;
        if (this.overrideOwner) {
            return new AdlFileStatus(entry, p, this.userName, "hdfs", aclBit);
        }
        return new AdlFileStatus(entry, p, aclBit);
    }

    @Override
    public void setOwner(Path path, String owner, String group) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.adlClient.setOwner(this.toRelativeFilePath(path), owner, group);
    }

    @Override
    public void setPermission(Path path, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.adlClient.setPermission(this.toRelativeFilePath(path), Integer.toOctalString(permission.toShort()));
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        ArrayList<io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclEntry> msAclEntries = new ArrayList<io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclEntry>();
        for (AclEntry aclEntry : aclSpec) {
            msAclEntries.add(io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclEntry.parseAclEntry(aclEntry.toString()));
        }
        this.adlClient.modifyAclEntries(this.toRelativeFilePath(path), msAclEntries);
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        ArrayList<io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclEntry> msAclEntries = new ArrayList<io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclEntry>();
        for (AclEntry aclEntry : aclSpec) {
            msAclEntries.add(io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclEntry.parseAclEntry(aclEntry.toString(), true));
        }
        this.adlClient.removeAclEntries(this.toRelativeFilePath(path), msAclEntries);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.adlClient.removeDefaultAcls(this.toRelativeFilePath(path));
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.adlClient.removeAllAcls(this.toRelativeFilePath(path));
    }

    @Override
    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        ArrayList<io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclEntry> msAclEntries = new ArrayList<io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclEntry>();
        for (AclEntry aclEntry : aclSpec) {
            msAclEntries.add(io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclEntry.parseAclEntry(aclEntry.toString()));
        }
        this.adlClient.setAcl(this.toRelativeFilePath(path), msAclEntries);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        this.statistics.incrementReadOps(1);
        io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclStatus adlStatus = this.adlClient.getAclStatus(this.toRelativeFilePath(path), this.oidOrUpn);
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner(adlStatus.owner);
        aclStatusBuilder.group(adlStatus.group);
        aclStatusBuilder.setPermission(new FsPermission(Short.valueOf(adlStatus.octalPermissions, 8)));
        aclStatusBuilder.stickyBit(adlStatus.stickyBit);
        String aclListString = io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclEntry.aclListToString(adlStatus.aclSpec);
        List<AclEntry> aclEntries = AclEntry.parseAclSpec(aclListString, true);
        aclStatusBuilder.addEntries(aclEntries);
        return aclStatusBuilder.build();
    }

    @Override
    public void access(Path path, FsAction mode) throws IOException {
        this.statistics.incrementReadOps(1);
        if (!this.adlClient.checkAccess(this.toRelativeFilePath(path), mode.SYMBOL)) {
            throw new AccessControlException("Access Denied : " + path.toString());
        }
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.ContentSummary msSummary = this.adlClient.getContentSummary(this.toRelativeFilePath(f));
        return new ContentSummary.Builder().length(msSummary.length).directoryCount(msSummary.directoryCount).fileCount(msSummary.fileCount).spaceConsumed(msSummary.spaceConsumed).build();
    }

    @VisibleForTesting
    protected String getTransportScheme() {
        return "https";
    }

    @VisibleForTesting
    String toRelativeFilePath(Path path) {
        return path.makeQualified(this.uri, this.workingDirectory).toUri().getPath();
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(Path dir) {
        if (dir == null) {
            throw new InvalidPathException("Working directory cannot be set to NULL");
        }
        this.workingDirectory = this.makeAbsolute(dir);
    }

    @Override
    @Deprecated
    public long getDefaultBlockSize() {
        return 0x10000000L;
    }

    @Override
    public long getDefaultBlockSize(Path f) {
        return this.getDefaultBlockSize();
    }

    @Override
    @Deprecated
    public long getBlockSize(Path f) throws IOException {
        return 0x10000000L;
    }

    @Override
    @Deprecated
    public short getReplication(Path src) {
        return 1;
    }

    private Path makeAbsolute(Path path) {
        return path.isAbsolute() ? path : new Path(this.workingDirectory, path);
    }

    private static String getNonEmptyVal(Configuration conf, String key) {
        String value = conf.get(key);
        if (StringUtils.isEmpty(value)) {
            throw new IllegalArgumentException("No value for " + key + " found in conf file.");
        }
        return value;
    }

    private static String getPasswordString(Configuration conf, String key) throws IOException {
        char[] passchars = conf.getPassword(key);
        if (passchars == null) {
            throw new IOException("Password " + key + " not found");
        }
        return new String(passchars);
    }

    @VisibleForTesting
    public void setUserGroupRepresentationAsUPN(boolean enableUPN) {
        this.oidOrUpn = enableUPN ? UserGroupRepresentation.UPN : UserGroupRepresentation.OID;
    }

    public static String getAccountNameFromFQDN(String accountFQDN) {
        return accountFQDN.contains(".") ? accountFQDN.substring(0, accountFQDN.indexOf(".")) : accountFQDN;
    }

    public static Configuration propagateAccountOptions(Configuration source, String accountName) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(accountName), "accountName");
        String accountPrefix = "fs.adl.account." + accountName + '.';
        LOG.debug("Propagating entries under {}", (Object)accountPrefix);
        Configuration dest = new Configuration(source);
        for (Map.Entry<String, String> entry : source) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.startsWith(accountPrefix) || accountPrefix.equals(key)) continue;
            String stripped = key.substring(accountPrefix.length());
            String origin = "[" + StringUtils.join((Object[])source.getPropertySources(key), ", ") + "]";
            String generic = "fs.adl." + stripped;
            LOG.debug("Updating {} from {}", (Object)generic, (Object)origin);
            dest.set(generic, value, key + " via " + origin);
        }
        return dest;
    }

    @Override
    public boolean hasPathCapability(Path path, String capability) throws IOException {
        switch (PathCapabilitiesSupport.validatePathCapabilityArgs(this.makeQualified(path), capability)) {
            case "fs.capability.paths.acls": 
            case "fs.capability.paths.append": 
            case "fs.capability.paths.concat": 
            case "fs.capability.paths.permissions": {
                return true;
            }
        }
        return super.hasPathCapability(path, capability);
    }

    static {
        AdlConfKeys.addDeprecatedKeys();
    }
}

