/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.aggregation;

import com.google.common.collect.ImmutableSet;
import io.trino.matching.Match;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.expression.ConnectorExpression;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class AggregateFunctionRewriter<AggregationResult, ExpressionResult> {
    private final ConnectorExpressionRewriter<ExpressionResult> connectorExpressionRewriter;
    private final Set<AggregateFunctionRule<AggregationResult, ExpressionResult>> rules;

    public AggregateFunctionRewriter(ConnectorExpressionRewriter<ExpressionResult> connectorExpressionRewriter, Set<AggregateFunctionRule<AggregationResult, ExpressionResult>> rules) {
        this.connectorExpressionRewriter = Objects.requireNonNull(connectorExpressionRewriter, "connectorExpressionRewriter is null");
        this.rules = ImmutableSet.copyOf((Collection)Objects.requireNonNull(rules, "rules is null"));
    }

    public Optional<AggregationResult> rewrite(final ConnectorSession session, AggregateFunction aggregateFunction, final Map<String, ColumnHandle> assignments) {
        Objects.requireNonNull(aggregateFunction, "aggregateFunction is null");
        Objects.requireNonNull(assignments, "assignments is null");
        AggregateFunctionRule.RewriteContext context = new AggregateFunctionRule.RewriteContext<ExpressionResult>(this){
            final /* synthetic */ AggregateFunctionRewriter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Map<String, ColumnHandle> getAssignments() {
                return assignments;
            }

            @Override
            public ConnectorSession getSession() {
                return session;
            }

            @Override
            public Optional<ExpressionResult> rewriteExpression(ConnectorExpression expression) {
                return this.this$0.connectorExpressionRewriter.rewrite(session, expression, assignments);
            }
        };
        for (AggregateFunctionRule<AggregationResult, ExpressionResult> rule : this.rules) {
            Iterator matches = rule.getPattern().match((Object)aggregateFunction, (Object)context).iterator();
            while (matches.hasNext()) {
                Match match = (Match)matches.next();
                Optional<AggregationResult> rewritten = rule.rewrite(aggregateFunction, match.captures(), context);
                if (!rewritten.isPresent()) continue;
                return rewritten;
            }
        }
        return Optional.empty();
    }
}

