/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.dictionary.DictionaryValuesWriter;
import org.apache.parquet.io.api.Binary;

public class DictionaryFallbackValuesWriter
extends ValuesWriter {
    private final ValuesWriter fallBackWriter;
    private boolean fellBackAlready;
    private ValuesWriter currentWriter;
    @Nullable
    private DictionaryValuesWriter initialWriter;
    private boolean initialUsedAndHadDictionary;
    private long rawDataByteSize;
    private boolean firstPage = true;

    public DictionaryFallbackValuesWriter(DictionaryValuesWriter initialWriter, ValuesWriter fallBackWriter) {
        this.initialWriter = initialWriter;
        this.fallBackWriter = fallBackWriter;
        this.currentWriter = initialWriter;
    }

    public long getBufferedSize() {
        return this.rawDataByteSize;
    }

    public BytesInput getBytes() {
        if (!this.fellBackAlready && this.firstPage) {
            BytesInput bytes = this.initialWriter.getBytes();
            if (!this.initialWriter.isCompressionSatisfying(this.rawDataByteSize, bytes.size())) {
                this.fallBack();
                this.initialWriter.close();
                this.initialWriter = null;
                Verify.verify((!this.initialUsedAndHadDictionary ? 1 : 0) != 0, (String)"initialUsedAndHadDictionary should be false when falling back to PLAIN in first page", (Object[])new Object[0]);
            } else {
                return bytes;
            }
        }
        return this.currentWriter.getBytes();
    }

    public Encoding getEncoding() {
        Encoding encoding = this.currentWriter.getEncoding();
        if (!this.fellBackAlready && !this.initialUsedAndHadDictionary) {
            this.initialUsedAndHadDictionary = encoding.usesDictionary();
        }
        return encoding;
    }

    public void reset() {
        this.rawDataByteSize = 0L;
        this.firstPage = false;
        this.currentWriter.reset();
    }

    public void close() {
        if (this.initialWriter != null) {
            this.initialWriter.close();
        }
        this.fallBackWriter.close();
    }

    public DictionaryPage toDictPageAndClose() {
        if (this.initialUsedAndHadDictionary) {
            return this.initialWriter.toDictPageAndClose();
        }
        return this.currentWriter.toDictPageAndClose();
    }

    public void resetDictionary() {
        if (this.initialUsedAndHadDictionary) {
            this.initialWriter.resetDictionary();
        } else {
            this.currentWriter.resetDictionary();
        }
        this.currentWriter = this.initialWriter;
        this.fellBackAlready = false;
        this.initialUsedAndHadDictionary = false;
        this.firstPage = true;
    }

    public long getAllocatedSize() {
        return this.fallBackWriter.getAllocatedSize() + (this.initialWriter != null ? this.initialWriter.getAllocatedSize() : 0L);
    }

    public String memUsageString(String prefix) {
        return String.format("%s FallbackValuesWriter{\n%s\n%s\n%s}\n", prefix, this.initialWriter != null ? this.initialWriter.memUsageString(prefix + " initial:") : "", this.fallBackWriter.memUsageString(prefix + " fallback:"), prefix);
    }

    public void writeByte(int value) {
        ++this.rawDataByteSize;
        this.currentWriter.writeByte(value);
        this.checkFallback();
    }

    public void writeBytes(Binary value) {
        this.rawDataByteSize += (long)(value.length() + 4);
        this.currentWriter.writeBytes(value);
        this.checkFallback();
    }

    public void writeInteger(int value) {
        this.rawDataByteSize += 4L;
        this.currentWriter.writeInteger(value);
        this.checkFallback();
    }

    public void writeLong(long value) {
        this.rawDataByteSize += 8L;
        this.currentWriter.writeLong(value);
        this.checkFallback();
    }

    public void writeFloat(float value) {
        this.rawDataByteSize += 4L;
        this.currentWriter.writeFloat(value);
        this.checkFallback();
    }

    public void writeDouble(double value) {
        this.rawDataByteSize += 8L;
        this.currentWriter.writeDouble(value);
        this.checkFallback();
    }

    @VisibleForTesting
    public DictionaryValuesWriter getInitialWriter() {
        return Objects.requireNonNull(this.initialWriter, "initialWriter is null");
    }

    @VisibleForTesting
    public ValuesWriter getFallBackWriter() {
        return this.fallBackWriter;
    }

    private void checkFallback() {
        if (!this.fellBackAlready && this.initialWriter.shouldFallBack()) {
            this.fallBack();
        }
    }

    private void fallBack() {
        this.fellBackAlready = true;
        this.initialWriter.fallBackAllValuesTo(this.fallBackWriter);
        this.currentWriter = this.fallBackWriter;
    }
}

