/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import com.google.common.math.LongMath;
import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.Type;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class TimestampNanosValueWriter
extends PrimitiveValueWriter {
    private final Type type;

    public TimestampNanosValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @Override
    public void write(Block block) {
        ValuesWriter valuesWriter = Objects.requireNonNull(this.getValuesWriter(), "valuesWriter is null");
        Statistics<?> statistics = Objects.requireNonNull(this.getStatistics(), "statistics is null");
        boolean mayHaveNull = block.mayHaveNull();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (mayHaveNull && block.isNull(i)) continue;
            LongTimestamp value = (LongTimestamp)this.type.getObject(block, i);
            long epochNanos = Math.multiplyExact(value.getEpochMicros(), 1000) + LongMath.divide((long)value.getPicosOfMicro(), (long)1000L, (RoundingMode)RoundingMode.UNNECESSARY);
            valuesWriter.writeLong(epochNanos);
            statistics.updateStats(epochNanos);
        }
    }
}

