/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import org.apache.pinot.common.utils.RoaringBitmapUtils;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.RoaringBitmap;

public class DistinctCountBitmapValueAggregator
implements ValueAggregator<Object, RoaringBitmap> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private int _maxByteSize;

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.DISTINCTCOUNTBITMAP;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public RoaringBitmap getInitialAggregatedValue(Object rawValue) {
        RoaringBitmap initialValue;
        if (rawValue instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            initialValue = this.deserializeAggregatedValue(bytes);
            this._maxByteSize = Math.max(this._maxByteSize, bytes.length);
        } else {
            initialValue = new RoaringBitmap();
            initialValue.add(rawValue.hashCode());
            this._maxByteSize = Math.max(this._maxByteSize, initialValue.serializedSizeInBytes());
        }
        return initialValue;
    }

    @Override
    public RoaringBitmap applyRawValue(RoaringBitmap value, Object rawValue) {
        if (rawValue instanceof byte[]) {
            value.or(this.deserializeAggregatedValue((byte[])rawValue));
        } else {
            value.add(rawValue.hashCode());
        }
        this._maxByteSize = Math.max(this._maxByteSize, value.serializedSizeInBytes());
        return value;
    }

    @Override
    public RoaringBitmap applyAggregatedValue(RoaringBitmap value, RoaringBitmap aggregatedValue) {
        value.or(aggregatedValue);
        this._maxByteSize = Math.max(this._maxByteSize, value.serializedSizeInBytes());
        return value;
    }

    @Override
    public RoaringBitmap cloneAggregatedValue(RoaringBitmap value) {
        return value.clone();
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return this._maxByteSize;
    }

    @Override
    public byte[] serializeAggregatedValue(RoaringBitmap value) {
        return RoaringBitmapUtils.serialize((ImmutableBitmapDataProvider)value);
    }

    @Override
    public RoaringBitmap deserializeAggregatedValue(byte[] bytes) {
        return RoaringBitmapUtils.deserialize((byte[])bytes);
    }
}

