/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.local.utils.CustomSerDeUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class DistinctCountThetaSketchValueAggregator
implements ValueAggregator<Object, Object> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private final SetOperationBuilder _setOperationBuilder = Union.builder().setNominalEntries(16384);
    private int _maxByteSize;

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.DISTINCTCOUNTTHETASKETCH;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    private void singleItemUpdate(Union thetaUnion, Object rawValue) {
        if (rawValue instanceof String) {
            thetaUnion.update((String)rawValue);
        } else if (rawValue instanceof Integer) {
            thetaUnion.update((long)((Integer)rawValue).intValue());
        } else if (rawValue instanceof Long) {
            thetaUnion.update(((Long)rawValue).longValue());
        } else if (rawValue instanceof Double) {
            thetaUnion.update(((Double)rawValue).doubleValue());
        } else if (rawValue instanceof Float) {
            thetaUnion.update((double)((Float)rawValue).floatValue());
        } else if (rawValue instanceof Object[]) {
            this.multiItemUpdate(thetaUnion, (Object[])rawValue);
        } else if (rawValue instanceof Sketch) {
            thetaUnion.union((Sketch)rawValue);
        } else if (rawValue instanceof Union) {
            thetaUnion.union((Sketch)((Union)rawValue).getResult());
        } else {
            throw new IllegalStateException("Unsupported data type for Theta Sketch aggregation: " + rawValue.getClass().getSimpleName());
        }
    }

    private void multiItemUpdate(Union thetaUnion, Object[] rawValues) {
        if (rawValues instanceof String[]) {
            for (String s : (String[])rawValues) {
                thetaUnion.update(s);
            }
        } else if (rawValues instanceof Integer[]) {
            for (Integer i : (Integer[])rawValues) {
                thetaUnion.update((long)i.intValue());
            }
        } else if (rawValues instanceof Long[]) {
            for (Long l : (Long[])rawValues) {
                thetaUnion.update(l.longValue());
            }
        } else if (rawValues instanceof Double[]) {
            for (Double d : (Double[])rawValues) {
                thetaUnion.update(d.doubleValue());
            }
        } else if (rawValues instanceof Float[]) {
            for (Float f : (Float[])rawValues) {
                thetaUnion.update((double)f.floatValue());
            }
        } else {
            throw new IllegalStateException("Unsupported data type for Theta Sketch aggregation: " + rawValues.getClass().getSimpleName());
        }
    }

    @Override
    public Object getInitialAggregatedValue(Object rawValue) {
        Union thetaUnion = this._setOperationBuilder.buildUnion();
        if (rawValue instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            Sketch sketch = this.deserializeAggregatedValue(bytes);
            thetaUnion.union(sketch);
        } else if (rawValue instanceof byte[][]) {
            byte[][] serializedSketches;
            for (byte[] sketchBytes : serializedSketches = (byte[][])rawValue) {
                thetaUnion.union(this.deserializeAggregatedValue(sketchBytes));
            }
        } else {
            this.singleItemUpdate(thetaUnion, rawValue);
        }
        this._maxByteSize = Math.max(this._maxByteSize, thetaUnion.getCurrentBytes());
        return thetaUnion;
    }

    private Union extractUnion(Object value) {
        if (value == null) {
            return this._setOperationBuilder.buildUnion();
        }
        if (value instanceof Union) {
            return (Union)value;
        }
        if (value instanceof Sketch) {
            Sketch sketch = (Sketch)value;
            Union thetaUnion = this._setOperationBuilder.buildUnion();
            thetaUnion.union(sketch);
            return thetaUnion;
        }
        throw new IllegalStateException("Unsupported data type for Theta Sketch aggregation: " + value.getClass().getSimpleName());
    }

    @Override
    public Object applyRawValue(Object aggregatedValue, Object rawValue) {
        Union thetaUnion = this.extractUnion(aggregatedValue);
        if (rawValue instanceof byte[]) {
            Sketch sketch = this.deserializeAggregatedValue((byte[])rawValue);
            thetaUnion.union(sketch);
        } else {
            this.singleItemUpdate(thetaUnion, rawValue);
        }
        this._maxByteSize = Math.max(this._maxByteSize, thetaUnion.getCurrentBytes());
        return thetaUnion;
    }

    @Override
    public Object applyAggregatedValue(Object value, Object aggregatedValue) {
        Union thetaUnion = this.extractUnion(aggregatedValue);
        this.singleItemUpdate(thetaUnion, value);
        this._maxByteSize = Math.max(this._maxByteSize, thetaUnion.getCurrentBytes());
        return thetaUnion;
    }

    @Override
    public Object cloneAggregatedValue(Object value) {
        return this.deserializeAggregatedValue(this.serializeAggregatedValue(value));
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return this._maxByteSize;
    }

    @Override
    public byte[] serializeAggregatedValue(Object value) {
        if (value instanceof Union) {
            return CustomSerDeUtils.DATA_SKETCH_THETA_SER_DE.serialize((Sketch)((Union)value).getResult());
        }
        if (value instanceof Sketch) {
            return CustomSerDeUtils.DATA_SKETCH_THETA_SER_DE.serialize((Sketch)value);
        }
        throw new IllegalStateException("Unsupported data type for Theta Sketch aggregation: " + value.getClass().getSimpleName());
    }

    @Override
    public Sketch deserializeAggregatedValue(byte[] bytes) {
        return CustomSerDeUtils.DATA_SKETCH_THETA_SER_DE.deserialize(bytes);
    }
}

