/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import com.google.common.base.Preconditions;
import java.util.Base64;
import org.apache.datasketches.kll.KllDoublesSketch;

public class SerializedKLL
implements Comparable<SerializedKLL> {
    private final double _quantile;
    private final KllDoublesSketch _sketch;

    public SerializedKLL(KllDoublesSketch sketch, double percentile) {
        this._sketch = sketch;
        this._quantile = percentile / 100.0;
    }

    @Override
    public int compareTo(SerializedKLL other) {
        Preconditions.checkArgument((other._quantile == this._quantile ? 1 : 0) != 0, (Object)"Quantile numbers don't match");
        return Double.compare(this._sketch.getQuantile(this._quantile), other._sketch.getQuantile(this._quantile));
    }

    public String toString() {
        return Base64.getEncoder().encodeToString(this._sketch.toByteArray());
    }
}

