/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4CompressorWithLength;
import org.apache.pinot.segment.local.io.compression.LZ4Compressor;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkCompressor;

class LZ4WithLengthCompressor
implements ChunkCompressor {
    static final LZ4WithLengthCompressor INSTANCE = new LZ4WithLengthCompressor();
    private final LZ4CompressorWithLength _compressor = new LZ4CompressorWithLength(LZ4Compressor.LZ4_FACTORY.fastCompressor());

    private LZ4WithLengthCompressor() {
    }

    public int compress(ByteBuffer inUncompressed, ByteBuffer outCompressed) throws IOException {
        this._compressor.compress(inUncompressed, outCompressed);
        outCompressed.flip();
        return outCompressed.limit();
    }

    public int maxCompressedSize(int uncompressedSize) {
        return this._compressor.maxCompressedLength(uncompressedSize);
    }

    public ChunkCompressionType compressionType() {
        return ChunkCompressionType.LZ4_LENGTH_PREFIXED;
    }
}

