/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.pinot.segment.local.io.util.FixedBitIntReaderWriter;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class FixedBitMVEntryDictForwardIndexWriter
implements Closeable {
    public static final int MAGIC_MARKER = -5517841;
    public static final short VERSION = 1;
    public static final int HEADER_SIZE = 24;
    private final Object2IntOpenHashMap<IntArrayList> _entryToIdMap = new Object2IntOpenHashMap();
    private final File _file;
    private final int _numBitsPerValue;
    private final IntArrayList _ids;

    public FixedBitMVEntryDictForwardIndexWriter(File file, int numDocs, int numBitsPerValue) {
        this._file = file;
        this._numBitsPerValue = numBitsPerValue;
        this._ids = new IntArrayList(numDocs);
    }

    public void putDictIds(int[] dictIds) {
        this._ids.add(this._entryToIdMap.computeIntIfAbsent((Object)IntArrayList.wrap((int[])dictIds), k -> this._entryToIdMap.size()));
    }

    @Override
    public void close() throws IOException {
        int numUniqueEntries = this._entryToIdMap.size();
        int[][] idToDictIdsMap = new int[numUniqueEntries][];
        int numTotalValues = 0;
        for (Object2IntMap.Entry entry : this._entryToIdMap.object2IntEntrySet()) {
            int id = entry.getIntValue();
            int[] dictIds = ((IntArrayList)entry.getKey()).elements();
            idToDictIdsMap[id] = dictIds;
            numTotalValues += dictIds.length;
        }
        int[] ids = this._ids.elements();
        int numBitsPerId = PinotDataBitSet.getNumBitsPerValue(numUniqueEntries - 1);
        int idBufferSize = (int)(((long)ids.length * (long)numBitsPerId + 7L) / 8L);
        int numBitsPerOffset = PinotDataBitSet.getNumBitsPerValue(numTotalValues);
        int offsetBufferSize = (int)(((long)(numUniqueEntries + 1) * (long)numBitsPerOffset + 7L) / 8L);
        int valueBufferSize = (int)(((long)numTotalValues * (long)this._numBitsPerValue + 7L) / 8L);
        int offsetBufferOffset = 24 + idBufferSize;
        int valueBufferOffset = offsetBufferOffset + offsetBufferSize;
        int indexSize = valueBufferOffset + valueBufferSize;
        try (PinotDataBuffer indexBuffer = PinotDataBuffer.mapFile((File)this._file, (boolean)false, (long)0L, (long)indexSize, (ByteOrder)ByteOrder.BIG_ENDIAN, (String)this.getClass().getSimpleName());){
            indexBuffer.putInt(0, -5517841);
            indexBuffer.putShort(4, (short)1);
            indexBuffer.putByte(6, (byte)this._numBitsPerValue);
            indexBuffer.putByte(7, (byte)numBitsPerId);
            indexBuffer.putInt(8, numUniqueEntries);
            indexBuffer.putInt(12, numTotalValues);
            indexBuffer.putInt(16, offsetBufferOffset);
            indexBuffer.putInt(20, valueBufferOffset);
            try (FixedBitIntReaderWriter idWriter = new FixedBitIntReaderWriter(indexBuffer.view(24L, (long)offsetBufferOffset), ids.length, numBitsPerId);){
                idWriter.writeInt(0, ids.length, ids);
            }
            try (FixedBitIntReaderWriter offsetWriter = new FixedBitIntReaderWriter(indexBuffer.view((long)offsetBufferOffset, (long)valueBufferOffset), numUniqueEntries + 1, numBitsPerOffset);
                 FixedBitIntReaderWriter valueWriter = new FixedBitIntReaderWriter(indexBuffer.view((long)valueBufferOffset, (long)indexSize), numTotalValues, this._numBitsPerValue);){
                int startOffset = 0;
                for (int i = 0; i < numUniqueEntries; ++i) {
                    offsetWriter.writeInt(i, startOffset);
                    int[] dictIds = idToDictIdsMap[i];
                    valueWriter.writeInt(startOffset, dictIds.length, dictIds);
                    startOffset += dictIds.length;
                }
                offsetWriter.writeInt(numUniqueEntries, startOffset);
            }
        }
    }
}

