/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.segment.local.io.writer.impl.BaseChunkForwardIndexWriter;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkWriter;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.spi.utils.BigDecimalUtils;

@NotThreadSafe
public class VarByteChunkForwardIndexWriter
extends BaseChunkForwardIndexWriter
implements VarByteChunkWriter {
    public static final int CHUNK_HEADER_ENTRY_ROW_OFFSET_SIZE = 4;
    private final int _chunkHeaderSize;
    private int _chunkHeaderOffset = 0;
    private int _chunkDataOffSet;

    public VarByteChunkForwardIndexWriter(File file, ChunkCompressionType compressionType, int totalDocs, int numDocsPerChunk, int lengthOfLongestEntry, int writerVersion) throws IOException {
        super(file, compressionType, totalDocs, numDocsPerChunk, (long)numDocsPerChunk * (4L + (long)lengthOfLongestEntry), lengthOfLongestEntry, writerVersion, false);
        this._chunkDataOffSet = this._chunkHeaderSize = numDocsPerChunk * 4;
    }

    @Override
    public void putBigDecimal(BigDecimal value) {
        this.putBytes(BigDecimalUtils.serialize((BigDecimal)value));
    }

    @Override
    public void putString(String value) {
        this.putBytes(value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void putBytes(byte[] value) {
        this._chunkBuffer.putInt(this._chunkHeaderOffset, this._chunkDataOffSet);
        this._chunkHeaderOffset += 4;
        this._chunkBuffer.position(this._chunkDataOffSet);
        this._chunkBuffer.put(value);
        this._chunkDataOffSet += value.length;
        this.writeChunkIfNecessary();
    }

    @Override
    public void putStringMV(String[] values) {
        this._chunkBuffer.putInt(this._chunkHeaderOffset, this._chunkDataOffSet);
        this._chunkHeaderOffset += 4;
        this._chunkBuffer.putInt(this._chunkDataOffSet, values.length);
        this._chunkDataOffSet += 4;
        int headerSize = 4 * values.length;
        int bodyPosition = this._chunkDataOffSet + headerSize;
        this._chunkBuffer.position(bodyPosition);
        int bodySize = 0;
        int i = 0;
        int h = this._chunkDataOffSet;
        while (i < values.length) {
            byte[] utf8 = values[i].getBytes(StandardCharsets.UTF_8);
            this._chunkBuffer.putInt(h, utf8.length);
            this._chunkBuffer.put(utf8);
            bodySize += utf8.length;
            ++i;
            h += 4;
        }
        this._chunkDataOffSet += headerSize + bodySize;
        this.writeChunkIfNecessary();
    }

    @Override
    public void putBytesMV(byte[][] values) {
        this._chunkBuffer.putInt(this._chunkHeaderOffset, this._chunkDataOffSet);
        this._chunkHeaderOffset += 4;
        this._chunkBuffer.putInt(this._chunkDataOffSet, values.length);
        this._chunkDataOffSet += 4;
        int headerSize = 4 * values.length;
        int bodyPosition = this._chunkDataOffSet + headerSize;
        this._chunkBuffer.position(bodyPosition);
        int bodySize = 0;
        int i = 0;
        int h = this._chunkDataOffSet;
        while (i < values.length) {
            byte[] bytes = values[i];
            this._chunkBuffer.putInt(h, bytes.length);
            this._chunkBuffer.put(bytes);
            bodySize += bytes.length;
            ++i;
            h += 4;
        }
        this._chunkDataOffSet += headerSize + bodySize;
        this.writeChunkIfNecessary();
    }

    private void writeChunkIfNecessary() {
        if (this._chunkHeaderOffset == this._chunkHeaderSize) {
            this.writeChunk();
        }
    }

    @Override
    protected void writeChunk() {
        for (int i = this._chunkHeaderOffset; i < this._chunkHeaderSize; i += 4) {
            this._chunkBuffer.putInt(i, 0);
        }
        super.writeChunk();
        this._chunkHeaderOffset = 0;
        this._chunkDataOffSet = this._chunkHeaderSize;
    }
}

