/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.forward;

import com.yscope.clp.compressorfrontend.EncodedMessage;
import com.yscope.clp.compressorfrontend.MessageDecoder;
import com.yscope.clp.compressorfrontend.MessageEncoder;
import java.io.IOException;
import org.apache.pinot.segment.local.realtime.impl.dictionary.StringOffHeapMutableDictionary;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteMVMutableForwardIndex;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteSVMutableForwardIndex;
import org.apache.pinot.segment.local.segment.creator.impl.stats.CLPStatsProvider;
import org.apache.pinot.segment.spi.index.mutable.MutableDictionary;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.spi.data.FieldSpec;

public class CLPMutableForwardIndex
implements MutableForwardIndex {
    private static final int ESTIMATED_LOG_TYPE_CARDINALITY = 10000;
    private static final int ESTIMATED_DICT_VARS_CARDINALITY = 10000;
    private static final int ESTIMATED_LOG_TYPE_LENGTH = 200;
    private static final int ESTIMATED_DICT_VARS_LENGTH = 50;
    private FieldSpec.DataType _storedType;
    private final EncodedMessage _clpEncodedMessage = new EncodedMessage();
    private final MessageEncoder _clpMessageEncoder = new MessageEncoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
    private final MessageDecoder _clpMessageDecoder;
    private final MutableDictionary _logTypeDictCreator;
    private final MutableDictionary _dictVarsDictCreator;
    private final FixedByteSVMutableForwardIndex _logTypeFwdIndex;
    private final FixedByteMVMutableForwardIndex _dictVarsFwdIndex;
    private final FixedByteMVMutableForwardIndex _encodedVarsFwdIndex;
    int _totalNumberOfDictVars = 0;
    int _maxNumberOfEncodedVars = 0;
    int _totalNumberOfEncodedVars = 0;
    private int _lengthOfShortestElement;
    private int _lengthOfLongestElement;

    public CLPMutableForwardIndex(String columnName, FieldSpec.DataType storedType, PinotDataBufferMemoryManager memoryManager, int capacity) {
        this._logTypeDictCreator = new StringOffHeapMutableDictionary(10000, 1000, memoryManager, columnName + "_logType.dict", 200);
        this._dictVarsDictCreator = new StringOffHeapMutableDictionary(10000, 1000, memoryManager, columnName + "_dictVars.dict", 50);
        this._logTypeFwdIndex = new FixedByteSVMutableForwardIndex(true, FieldSpec.DataType.INT, capacity, memoryManager, columnName + "_logType.fwd");
        this._dictVarsFwdIndex = new FixedByteMVMutableForwardIndex(1000, 20, capacity, 4, memoryManager, columnName + "_dictVars.fwd", true, FieldSpec.DataType.INT);
        this._encodedVarsFwdIndex = new FixedByteMVMutableForwardIndex(1000, 20, capacity, 8, memoryManager, columnName + "_encodedVars.fwd", true, FieldSpec.DataType.LONG);
        this._clpMessageDecoder = new MessageDecoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
        this._storedType = storedType;
    }

    public int getLengthOfShortestElement() {
        return this._lengthOfShortestElement;
    }

    public int getLengthOfLongestElement() {
        return this._lengthOfLongestElement;
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getStoredType() {
        return this._storedType;
    }

    public void setString(int docId, String value) {
        Long[] encodedVars;
        String[] dictVars;
        String logtype;
        this._lengthOfLongestElement = Math.max(this._lengthOfLongestElement, value.length());
        this._lengthOfShortestElement = Math.min(this._lengthOfShortestElement, value.length());
        try {
            this._clpMessageEncoder.encodeMessage(value, this._clpEncodedMessage);
            logtype = this._clpEncodedMessage.getLogTypeAsString();
            dictVars = this._clpEncodedMessage.getDictionaryVarsAsStrings();
            encodedVars = this._clpEncodedMessage.getEncodedVarsAsBoxedLongs();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to encode message: " + value, e);
        }
        this._totalNumberOfDictVars += dictVars.length;
        this._totalNumberOfEncodedVars += encodedVars.length;
        this._maxNumberOfEncodedVars = Math.max(this._maxNumberOfEncodedVars, encodedVars.length);
        int logTypeDictId = this._logTypeDictCreator.index((Object)logtype);
        this._logTypeFwdIndex.setDictId(docId, logTypeDictId);
        int[] dictVarsDictIds = new int[dictVars.length];
        for (int i = 0; i < dictVars.length; ++i) {
            dictVarsDictIds[i] = this._dictVarsDictCreator.index((Object)dictVars[i]);
        }
        this._dictVarsFwdIndex.setDictIdMV(docId, dictVarsDictIds);
        long[] encodedVarsLongs = new long[encodedVars.length];
        for (int i = 0; i < encodedVars.length; ++i) {
            encodedVarsLongs[i] = encodedVars[i];
        }
        this._encodedVarsFwdIndex.setLongMV(docId, encodedVarsLongs);
    }

    public String getString(int docId) {
        String logType = this._logTypeDictCreator.getStringValue(this._logTypeFwdIndex.getDictId(docId));
        int[] dictVarsDictIds = this._dictVarsFwdIndex.getDictIdMV(docId);
        String[] dictVars = new String[dictVarsDictIds.length];
        for (int i = 0; i < dictVarsDictIds.length; ++i) {
            dictVars[i] = this._dictVarsDictCreator.getStringValue(dictVarsDictIds[i]);
        }
        long[] encodedVarsLongs = this._encodedVarsFwdIndex.getLongMV(docId);
        try {
            return this._clpMessageDecoder.decodeMessage(logType, dictVars, encodedVarsLongs);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to encode message: " + logType, e);
        }
    }

    public CLPStatsProvider.CLPStats getCLPStats() {
        return new CLPStatsProvider.CLPStats((String[])this._logTypeDictCreator.getSortedValues(), (String[])this._dictVarsDictCreator.getSortedValues(), this._totalNumberOfDictVars, this._totalNumberOfEncodedVars, this._maxNumberOfEncodedVars);
    }

    public void close() throws IOException {
        this._logTypeDictCreator.close();
        this._dictVarsDictCreator.close();
        this._logTypeFwdIndex.close();
        this._dictVarsFwdIndex.close();
        this._encodedVarsFwdIndex.close();
    }
}

