/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import java.util.HashMap;
import java.util.Map;

class ExtraFieldsContainer {
    private Map<String, Object> _indexableExtras = null;
    private Map<String, Object> _unindexableExtras = null;
    private final boolean _storeUnindexableExtras;

    ExtraFieldsContainer(boolean storeUnindexableExtras) {
        this._storeUnindexableExtras = storeUnindexableExtras;
    }

    public Map<String, Object> getIndexableExtras() {
        return this._indexableExtras;
    }

    public Map<String, Object> getUnindexableExtras() {
        return this._unindexableExtras;
    }

    public void addIndexableEntry(String key, Object value) {
        if (null == this._indexableExtras) {
            this._indexableExtras = new HashMap<String, Object>();
        }
        if (key == null && value instanceof Map) {
            this._indexableExtras.putAll((Map)value);
        } else if (this._indexableExtras.containsKey(key) && this._indexableExtras.get(key) instanceof Map && value instanceof Map) {
            ((Map)this._indexableExtras.get(key)).putAll((Map)value);
        } else {
            this._indexableExtras.put(key, value);
        }
    }

    public void addUnindexableEntry(String key, Object value) {
        if (!this._storeUnindexableExtras) {
            return;
        }
        if (null == this._unindexableExtras) {
            this._unindexableExtras = new HashMap<String, Object>();
        }
        if (key == null && value instanceof Map) {
            this._unindexableExtras.putAll((Map)value);
        } else if (this._unindexableExtras.containsKey(key) && this._unindexableExtras.get(key) instanceof Map && value instanceof Map) {
            ((Map)this._unindexableExtras.get(key)).putAll((Map)value);
        } else {
            this._unindexableExtras.put(key, value);
        }
    }

    public void addChild(String key, ExtraFieldsContainer child) {
        Map<String, Object> childUnindexableFields;
        Map<String, Object> childIndexableFields = child.getIndexableExtras();
        if (null != childIndexableFields) {
            this.addIndexableEntry(key, childIndexableFields);
        }
        if (null != (childUnindexableFields = child.getUnindexableExtras())) {
            this.addUnindexableEntry(key, childUnindexableFields);
        }
    }

    public void addChild(ExtraFieldsContainer child) {
        this.addChild(null, child);
    }
}

