/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecialValueTransformer
implements RecordTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpecialValueTransformer.class);
    private final HashSet<String> _specialValuesKeySet = new HashSet();
    private int _negativeZeroConversionCount = 0;
    private int _nanConversionCount = 0;

    public SpecialValueTransformer(Schema schema) {
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn() || fieldSpec.getDataType() != FieldSpec.DataType.FLOAT && fieldSpec.getDataType() != FieldSpec.DataType.DOUBLE) continue;
            this._specialValuesKeySet.add(fieldSpec.getName());
        }
    }

    private Object transformNegativeZero(Object value) {
        if (value instanceof Float && Float.floatToRawIntBits(((Float)value).floatValue()) == Float.floatToRawIntBits(-0.0f)) {
            value = Float.valueOf(0.0f);
            ++this._negativeZeroConversionCount;
        } else if (value instanceof Double && Double.doubleToLongBits((Double)value) == Double.doubleToLongBits(-0.0)) {
            value = 0.0;
            ++this._negativeZeroConversionCount;
        }
        return value;
    }

    private Object transformNaN(Object value) {
        if (value instanceof Float && ((Float)value).isNaN()) {
            value = null;
            ++this._nanConversionCount;
        } else if (value instanceof Double && ((Double)value).isNaN()) {
            ++this._nanConversionCount;
            value = null;
        }
        return value;
    }

    @Override
    public boolean isNoOp() {
        return this._specialValuesKeySet.isEmpty();
    }

    @Override
    public GenericRow transform(GenericRow record) {
        for (String element : this._specialValuesKeySet) {
            Object value = record.getValue(element);
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                int numValues = values.length;
                ArrayList<Object> negativeZeroNanSanitizedValues = new ArrayList<Object>(numValues);
                for (Object o : values) {
                    Object zeroTransformedValue = this.transformNegativeZero(o);
                    Object nanTransformedValue = this.transformNaN(zeroTransformedValue);
                    if (nanTransformedValue == null) continue;
                    negativeZeroNanSanitizedValues.add(nanTransformedValue);
                }
                record.putValue(element, (Object)negativeZeroNanSanitizedValues.toArray());
                continue;
            }
            Object zeroTransformedValue = this.transformNegativeZero(value);
            Object nanTransformedValue = this.transformNaN(zeroTransformedValue);
            if (nanTransformedValue == value) continue;
            record.putValue(element, nanTransformedValue);
        }
        if (this._negativeZeroConversionCount > 0 || this._nanConversionCount > 0) {
            LOGGER.debug("Converted {} -0.0s to 0.0 and {} NaNs to null", (Object)this._negativeZeroConversionCount, (Object)this._nanConversionCount);
        }
        return record;
    }

    @VisibleForTesting
    int getNegativeZeroConversionCount() {
        return this._negativeZeroConversionCount;
    }

    @VisibleForTesting
    int getNanConversionCount() {
        return this._nanConversionCount;
    }
}

