/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import com.google.common.base.Preconditions;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.utils.TimeUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeValidationTransformer
implements RecordTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeValidationTransformer.class);
    private final String _timeColumnName;
    private final DateTimeFormatSpec _timeFormatSpec;
    private final boolean _enableTimeValueCheck;
    private final boolean _continueOnError;

    public TimeValidationTransformer(TableConfig tableConfig, Schema schema) {
        this._timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        if (this._timeColumnName != null) {
            DateTimeFieldSpec dateTimeFieldSpec = schema.getSpecForTimeColumn(this._timeColumnName);
            Preconditions.checkState((dateTimeFieldSpec != null ? 1 : 0) != 0, (String)"Failed to find spec for time column: %s from schema: %s", (Object)this._timeColumnName, (Object)schema.getSchemaName());
            this._timeFormatSpec = dateTimeFieldSpec.getFormatSpec();
            IngestionConfig ingestionConfig = tableConfig.getIngestionConfig();
            if (ingestionConfig != null) {
                this._enableTimeValueCheck = ingestionConfig.isRowTimeValueCheck();
                this._continueOnError = ingestionConfig.isContinueOnError();
            } else {
                this._enableTimeValueCheck = false;
                this._continueOnError = false;
            }
        } else {
            this._timeFormatSpec = null;
            this._enableTimeValueCheck = false;
            this._continueOnError = false;
        }
    }

    @Override
    public boolean isNoOp() {
        return !this._enableTimeValueCheck;
    }

    @Override
    public GenericRow transform(GenericRow record) {
        long timeValueMs;
        if (!this._enableTimeValueCheck) {
            return record;
        }
        Object timeValue = record.getValue(this._timeColumnName);
        if (timeValue == null) {
            return record;
        }
        try {
            timeValueMs = this._timeFormatSpec.fromFormatToMillis(timeValue.toString());
        }
        catch (Exception e) {
            String errorMessage = String.format("Caught exception while parsing time value: %s with format: %s", timeValue, this._timeFormatSpec);
            if (this._continueOnError) {
                LOGGER.debug(errorMessage);
                record.putValue(this._timeColumnName, null);
                return record;
            }
            throw new IllegalStateException(errorMessage);
        }
        if (!TimeUtils.timeValueInValidRange((long)timeValueMs)) {
            String errorMessage = String.format("Time value: %s is not in valid range: %s", new DateTime(timeValueMs, DateTimeZone.UTC), TimeUtils.VALID_TIME_INTERVAL);
            if (this._continueOnError) {
                LOGGER.debug(errorMessage);
                record.putValue(this._timeColumnName, null);
                record.putValue("$INCOMPLETE_RECORD_KEY$", (Object)true);
                return record;
            }
            throw new IllegalStateException(errorMessage);
        }
        return record;
    }
}

