/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator;

import org.apache.pinot.common.Utils;
import org.apache.pinot.segment.local.segment.creator.TransformPipeline;
import org.apache.pinot.segment.local.segment.creator.impl.stats.SegmentPreIndexStatsCollectorImpl;
import org.apache.pinot.segment.spi.creator.SegmentCreationDataSource;
import org.apache.pinot.segment.spi.creator.SegmentPreIndexStatsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.recordenricher.RecordEnricherPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordReaderSegmentCreationDataSource
implements SegmentCreationDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordReaderSegmentCreationDataSource.class);
    private final RecordReader _recordReader;
    private RecordEnricherPipeline _recordEnricherPipeline;
    private TransformPipeline _transformPipeline;

    public RecordReaderSegmentCreationDataSource(RecordReader recordReader) {
        this._recordReader = recordReader;
    }

    public void setRecordEnricherPipeline(RecordEnricherPipeline recordEnricherPipeline) {
        this._recordEnricherPipeline = recordEnricherPipeline;
    }

    public void setTransformPipeline(TransformPipeline transformPipeline) {
        this._transformPipeline = transformPipeline;
    }

    public SegmentPreIndexStatsCollector gatherStats(StatsCollectorConfig statsCollectorConfig) {
        try {
            RecordEnricherPipeline recordEnricherPipeline = this._recordEnricherPipeline != null ? this._recordEnricherPipeline : RecordEnricherPipeline.fromTableConfig((TableConfig)statsCollectorConfig.getTableConfig());
            TransformPipeline transformPipeline = this._transformPipeline != null ? this._transformPipeline : new TransformPipeline(statsCollectorConfig.getTableConfig(), statsCollectorConfig.getSchema());
            SegmentPreIndexStatsCollectorImpl collector = new SegmentPreIndexStatsCollectorImpl(statsCollectorConfig);
            collector.init();
            GenericRow reuse = new GenericRow();
            TransformPipeline.Result reusedResult = new TransformPipeline.Result();
            while (this._recordReader.hasNext()) {
                reuse.clear();
                reuse = this._recordReader.next(reuse);
                recordEnricherPipeline.run(reuse);
                transformPipeline.processRow(reuse, reusedResult);
                for (GenericRow row : reusedResult.getTransformedRows()) {
                    collector.collectRow(row);
                }
            }
            collector.build();
            return collector;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while gathering stats", (Throwable)e);
            Utils.rethrowException((Throwable)e);
            return null;
        }
    }

    public RecordReader getRecordReader() {
        try {
            this._recordReader.rewind();
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while rewinding record reader", (Throwable)e);
            Utils.rethrowException((Throwable)e);
        }
        return this._recordReader;
    }
}

