/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.local.io.writer.impl.FixedBitMVEntryDictForwardIndexWriter;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class MultiValueEntryDictForwardIndexCreator
implements ForwardIndexCreator {
    private final FixedBitMVEntryDictForwardIndexWriter _writer;

    public MultiValueEntryDictForwardIndexCreator(File outputDir, String column, int cardinality, int numDocs) {
        File indexFile = new File(outputDir, column + ".mv.fwd");
        int numBitsPerValue = PinotDataBitSet.getNumBitsPerValue(cardinality - 1);
        this._writer = new FixedBitMVEntryDictForwardIndexWriter(indexFile, numDocs, numBitsPerValue);
    }

    public boolean isDictionaryEncoded() {
        return true;
    }

    public boolean isSingleValue() {
        return false;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.INT;
    }

    public void putDictIdMV(int[] dictIds) {
        this._writer.putDictIds(dictIds);
    }

    public void close() throws IOException {
        this._writer.close();
    }
}

