/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv.geospatial;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.H3Utils;
import org.apache.pinot.segment.spi.index.creator.GeoSpatialIndexCreator;
import org.apache.pinot.segment.spi.index.reader.H3IndexResolution;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.roaringbitmap.BitmapDataProvider;
import org.roaringbitmap.Container;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.RoaringBitmapWriter;

public abstract class BaseH3IndexCreator
implements GeoSpatialIndexCreator {
    public static final int VERSION = 1;
    public static final int HEADER_LENGTH = 10;
    static final String TEMP_DIR_SUFFIX = ".h3.idx.tmp";
    static final String DICTIONARY_FILE_NAME = "dictionary.buf";
    static final String BITMAP_OFFSET_FILE_NAME = "bitmap.offset.buf";
    static final String BITMAP_VALUE_FILE_NAME = "bitmap.value.buf";
    final File _indexFile;
    final File _tempDir;
    final File _dictionaryFile;
    final File _bitmapOffsetFile;
    final File _bitmapValueFile;
    final DataOutputStream _dictionaryStream;
    final DataOutputStream _bitmapOffsetStream;
    final DataOutputStream _bitmapValueStream;
    final H3IndexResolution _resolution;
    final int _lowestResolution;
    final Map<Long, RoaringBitmapWriter<RoaringBitmap>> _postingListMap = new TreeMap<Long, RoaringBitmapWriter<RoaringBitmap>>();
    final RoaringBitmapWriter.Wizard<Container, RoaringBitmap> _bitmapWriterWizard = RoaringBitmapWriter.writer().runCompress(false);
    int _nextDocId;

    BaseH3IndexCreator(File indexDir, String columnName, H3IndexResolution resolution) throws IOException {
        this._indexFile = new File(indexDir, columnName + ".h3.idx");
        this._tempDir = new File(indexDir, columnName + TEMP_DIR_SUFFIX);
        if (this._tempDir.exists()) {
            FileUtils.cleanDirectory((File)this._tempDir);
        } else {
            FileUtils.forceMkdir((File)this._tempDir);
        }
        this._dictionaryFile = new File(this._tempDir, DICTIONARY_FILE_NAME);
        this._bitmapOffsetFile = new File(this._tempDir, BITMAP_OFFSET_FILE_NAME);
        this._bitmapValueFile = new File(this._tempDir, BITMAP_VALUE_FILE_NAME);
        this._dictionaryStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._dictionaryFile)));
        this._bitmapOffsetStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._bitmapOffsetFile)));
        this._bitmapValueStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._bitmapValueFile)));
        this._resolution = resolution;
        this._lowestResolution = resolution.getLowestResolution();
    }

    public Geometry deserialize(byte[] bytes) {
        return GeometrySerializer.deserialize(bytes);
    }

    public void add(Geometry geometry) throws IOException {
        Preconditions.checkState((boolean)(geometry instanceof Point), (String)"H3 index can only be applied to Point, got: %s", (Object)geometry.getGeometryType());
        Coordinate coordinate = geometry.getCoordinate();
        long h3Id = H3Utils.H3_CORE.geoToH3(coordinate.y, coordinate.x, this._lowestResolution);
        RoaringBitmapWriter bitmapWriter = this._postingListMap.get(h3Id);
        if (bitmapWriter == null) {
            bitmapWriter = this._bitmapWriterWizard.get();
            this._postingListMap.put(h3Id, (RoaringBitmapWriter<RoaringBitmap>)bitmapWriter);
        }
        bitmapWriter.add(this._nextDocId++);
    }

    void add(long h3Id, BitmapDataProvider bitmap) throws IOException {
        this._dictionaryStream.writeLong(h3Id);
        this._bitmapOffsetStream.writeInt(this._bitmapValueStream.size());
        bitmap.serialize((DataOutput)this._bitmapValueStream);
    }

    void generateIndexFile() throws IOException {
        this._bitmapOffsetStream.writeInt(this._bitmapValueStream.size());
        this._dictionaryStream.close();
        this._bitmapOffsetStream.close();
        this._bitmapValueStream.close();
        ByteBuffer headerBuffer = ByteBuffer.allocate(10);
        headerBuffer.putInt(1);
        headerBuffer.putInt(this._dictionaryStream.size() / 8);
        headerBuffer.putShort(this._resolution.serialize());
        headerBuffer.position(0);
        try (FileChannel indexFileChannel = new RandomAccessFile(this._indexFile, "rw").getChannel();
             FileChannel dictionaryFileChannel = new RandomAccessFile(this._dictionaryFile, "r").getChannel();
             FileChannel bitmapOffsetFileChannel = new RandomAccessFile(this._bitmapOffsetFile, "r").getChannel();
             FileChannel bitmapValueFileChannel = new RandomAccessFile(this._bitmapValueFile, "r").getChannel();){
            indexFileChannel.write(headerBuffer);
            org.apache.pinot.common.utils.FileUtils.transferBytes((FileChannel)dictionaryFileChannel, (long)0L, (long)this._dictionaryFile.length(), (FileChannel)indexFileChannel);
            org.apache.pinot.common.utils.FileUtils.transferBytes((FileChannel)bitmapOffsetFileChannel, (long)0L, (long)this._bitmapOffsetFile.length(), (FileChannel)indexFileChannel);
            org.apache.pinot.common.utils.FileUtils.transferBytes((FileChannel)bitmapValueFileChannel, (long)0L, (long)this._bitmapValueFile.length(), (FileChannel)indexFileChannel);
            indexFileChannel.force(true);
        }
    }

    public void close() throws IOException {
        this._dictionaryStream.close();
        this._bitmapOffsetStream.close();
        this._bitmapValueStream.close();
        FileUtils.deleteDirectory((File)this._tempDir);
    }
}

