/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Set;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.spi.utils.ByteArray;

public class BytesColumnPredIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private Set<ByteArray> _values = new ObjectOpenHashSet(1000);
    private int _minLength = Integer.MAX_VALUE;
    private int _maxLength = 0;
    private int _maxRowLength = 0;
    private ByteArray[] _sortedValues;
    private boolean _sealed = false;

    public BytesColumnPredIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    @Override
    public void collect(Object entry) {
        assert (!this._sealed);
        if (entry instanceof Object[]) {
            Object[] values = (Object[])entry;
            int rowLength = 0;
            for (Object obj : values) {
                ByteArray value = new ByteArray((byte[])obj);
                this._values.add(value);
                int length = value.length();
                this._minLength = Math.min(this._minLength, length);
                this._maxLength = Math.max(this._maxLength, length);
                rowLength += length;
            }
            this._maxNumberOfMultiValues = Math.max(this._maxNumberOfMultiValues, values.length);
            this._maxRowLength = Math.max(this._maxRowLength, rowLength);
            this.updateTotalNumberOfEntries(values);
        } else {
            ByteArray value = new ByteArray((byte[])entry);
            this.addressSorted((Comparable)value);
            if (this._values.add(value)) {
                if (this.isPartitionEnabled()) {
                    this.updatePartition(value.toString());
                }
                int length = value.length();
                this._minLength = Math.min(this._minLength, length);
                this._maxRowLength = this._maxLength = Math.max(this._maxLength, length);
            }
            ++this._totalNumberOfEntries;
        }
    }

    public ByteArray getMinValue() {
        if (this._sealed) {
            return this._sortedValues[0];
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    public ByteArray getMaxValue() {
        if (this._sealed) {
            return this._sortedValues[this._sortedValues.length - 1];
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    public ByteArray[] getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedValues;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    @Override
    public int getLengthOfShortestElement() {
        return this._minLength;
    }

    @Override
    public int getLengthOfLargestElement() {
        if (this._sealed) {
            return this._maxLength;
        }
        throw new IllegalStateException("you must seal the collector first before asking for longest value");
    }

    public int getMaxRowLengthInBytes() {
        return this._maxRowLength;
    }

    public int getCardinality() {
        if (this._sealed) {
            return this._sortedValues.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for cardinality");
    }

    @Override
    public void seal() {
        if (!this._sealed) {
            this._sortedValues = this._values.toArray(new ByteArray[0]);
            this._values = null;
            Arrays.sort(this._sortedValues);
            this._sealed = true;
        }
    }
}

