/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;

public class IntColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private IntSet _values = new IntOpenHashSet(1000);
    private int[] _sortedValues;
    private boolean _sealed = false;
    private int _prevValue = Integer.MIN_VALUE;

    public IntColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    @Override
    public void collect(Object entry) {
        assert (!this._sealed);
        if (entry instanceof Object[]) {
            Object[] values;
            for (Object obj : values = (Object[])entry) {
                int value = (Integer)obj;
                this._values.add(value);
            }
            this._maxNumberOfMultiValues = Math.max(this._maxNumberOfMultiValues, values.length);
            this.updateTotalNumberOfEntries(values);
        } else if (entry instanceof int[]) {
            int[] values;
            for (int value : values = (int[])entry) {
                this._values.add(value);
            }
            this._maxNumberOfMultiValues = Math.max(this._maxNumberOfMultiValues, values.length);
            this.updateTotalNumberOfEntries(values.length);
        } else {
            int value = (Integer)entry;
            this.addressSorted(value);
            if (this._values.add(value) && this.isPartitionEnabled()) {
                this.updatePartition(Integer.toString(value));
            }
            ++this._totalNumberOfEntries;
        }
    }

    private void addressSorted(int entry) {
        if (this._sorted) {
            this._sorted = entry >= this._prevValue;
            this._prevValue = entry;
        }
    }

    public Integer getMinValue() {
        if (this._sealed) {
            return this._sortedValues[0];
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    public Integer getMaxValue() {
        if (this._sealed) {
            return this._sortedValues[this._sortedValues.length - 1];
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    public Object getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedValues;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    public int getCardinality() {
        if (this._sealed) {
            return this._sortedValues.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for cardinality");
    }

    @Override
    public void seal() {
        if (!this._sealed) {
            this._sortedValues = this._values.toIntArray();
            this._values = null;
            Arrays.sort(this._sortedValues);
            this._sealed = true;
        }
    }
}

