/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.vector;

import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;

public class XKnnFloatVectorField
extends KnnFloatVectorField {
    public static final int MAX_DIMS_COUNT = 2048;

    private static FieldType createType(float[] v, final VectorSimilarityFunction similarityFunction) {
        if (v == null) {
            throw new IllegalArgumentException("vector value must not be null");
        }
        final int dimension = v.length;
        if (dimension == 0) {
            throw new IllegalArgumentException("cannot index an empty vector");
        }
        if (dimension > 2048) {
            throw new IllegalArgumentException("cannot index vectors with dimension greater than 2048");
        }
        if (similarityFunction == null) {
            throw new IllegalArgumentException("similarity function must not be null");
        }
        FieldType type = new FieldType(){

            public int vectorDimension() {
                return dimension;
            }

            public VectorEncoding vectorEncoding() {
                return VectorEncoding.FLOAT32;
            }

            public VectorSimilarityFunction vectorSimilarityFunction() {
                return similarityFunction;
            }
        };
        type.freeze();
        return type;
    }

    public XKnnFloatVectorField(String name, float[] vector, VectorSimilarityFunction similarityFunction) {
        super(name, vector, XKnnFloatVectorField.createType(vector, similarityFunction));
    }
}

