/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.column;

import java.math.BigDecimal;
import org.apache.pinot.segment.local.segment.index.column.BaseVirtualColumnProvider;
import org.apache.pinot.segment.local.segment.index.readers.ConstantValueBigDecimalDictionary;
import org.apache.pinot.segment.local.segment.index.readers.ConstantValueBytesDictionary;
import org.apache.pinot.segment.local.segment.index.readers.ConstantValueDoubleDictionary;
import org.apache.pinot.segment.local.segment.index.readers.ConstantValueFloatDictionary;
import org.apache.pinot.segment.local.segment.index.readers.ConstantValueIntDictionary;
import org.apache.pinot.segment.local.segment.index.readers.ConstantValueLongDictionary;
import org.apache.pinot.segment.local.segment.index.readers.ConstantValueStringDictionary;
import org.apache.pinot.segment.local.segment.index.readers.constant.ConstantMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.constant.ConstantMVInvertedIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.constant.ConstantSortedIndexReader;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.segment.spi.index.metadata.ColumnMetadataImpl;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;

public class DefaultNullValueVirtualColumnProvider
extends BaseVirtualColumnProvider {
    @Override
    public ForwardIndexReader<?> buildForwardIndex(VirtualColumnContext context) {
        if (context.getFieldSpec().isSingleValueField()) {
            return new ConstantSortedIndexReader(context.getTotalDocCount());
        }
        return new ConstantMVForwardIndexReader();
    }

    @Override
    public Dictionary buildDictionary(VirtualColumnContext context) {
        FieldSpec fieldSpec = context.getFieldSpec();
        switch (fieldSpec.getDataType().getStoredType()) {
            case INT: {
                return new ConstantValueIntDictionary((Integer)fieldSpec.getDefaultNullValue());
            }
            case LONG: {
                return new ConstantValueLongDictionary((Long)fieldSpec.getDefaultNullValue());
            }
            case FLOAT: {
                return new ConstantValueFloatDictionary(((Float)fieldSpec.getDefaultNullValue()).floatValue());
            }
            case DOUBLE: {
                return new ConstantValueDoubleDictionary((Double)fieldSpec.getDefaultNullValue());
            }
            case BIG_DECIMAL: {
                return new ConstantValueBigDecimalDictionary((BigDecimal)fieldSpec.getDefaultNullValue());
            }
            case STRING: {
                return new ConstantValueStringDictionary((String)fieldSpec.getDefaultNullValue());
            }
            case BYTES: {
                return new ConstantValueBytesDictionary((byte[])fieldSpec.getDefaultNullValue());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public InvertedIndexReader<?> buildInvertedIndex(VirtualColumnContext context) {
        if (context.getFieldSpec().isSingleValueField()) {
            return new ConstantSortedIndexReader(context.getTotalDocCount());
        }
        return new ConstantMVInvertedIndexReader(context.getTotalDocCount());
    }

    public ColumnMetadataImpl buildMetadata(VirtualColumnContext context) {
        ColumnMetadataImpl.Builder builder = this.getColumnMetadataBuilder(context).setCardinality(1).setHasDictionary(true);
        if (context.getFieldSpec().isSingleValueField()) {
            builder.setSorted(true);
        } else {
            builder.setMaxNumberOfMultiValues(1);
        }
        FieldSpec fieldSpec = context.getFieldSpec();
        Object defaultNullValue = fieldSpec.getDefaultNullValue();
        switch (fieldSpec.getDataType().getStoredType()) {
            case INT: {
                builder.setMinValue((Comparable)((Integer)defaultNullValue)).setMaxValue((Comparable)((Integer)defaultNullValue));
                break;
            }
            case LONG: {
                builder.setMinValue((Comparable)((Long)defaultNullValue)).setMaxValue((Comparable)((Long)defaultNullValue));
                break;
            }
            case FLOAT: {
                builder.setMinValue((Comparable)Float.valueOf(((Float)defaultNullValue).floatValue())).setMaxValue((Comparable)Float.valueOf(((Float)defaultNullValue).floatValue()));
                break;
            }
            case DOUBLE: {
                builder.setMinValue((Comparable)((Double)defaultNullValue)).setMaxValue((Comparable)((Double)defaultNullValue));
                break;
            }
            case BIG_DECIMAL: {
                builder.setMinValue((Comparable)((BigDecimal)defaultNullValue)).setMaxValue((Comparable)((BigDecimal)defaultNullValue));
                break;
            }
            case STRING: {
                builder.setMinValue((Comparable)((Object)((String)defaultNullValue))).setMaxValue((Comparable)((Object)((String)defaultNullValue)));
                break;
            }
            case BYTES: {
                builder.setMinValue((Comparable)new ByteArray((byte[])defaultNullValue)).setMaxValue((Comparable)new ByteArray((byte[])defaultNullValue));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return builder.build();
    }
}

