/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.dictionary.DictionaryIndexType;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexType;
import org.apache.pinot.segment.local.segment.index.loader.BaseIndexHandler;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.TextIndexConfig;
import org.apache.pinot.segment.spi.index.creator.TextIndexCreator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexHandler
extends BaseIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextIndexHandler.class);
    private final Set<String> _columnsToAddIdx;

    public TextIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> fieldIndexConfigs, @Nullable TableConfig tableConfig) {
        super(segmentDirectory, fieldIndexConfigs, tableConfig);
        this._columnsToAddIdx = FieldIndexConfigsUtil.columnsWithIndexEnabled((IndexType)StandardIndexes.text(), (Map)this._fieldIndexConfigs);
    }

    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._columnsToAddIdx);
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.text());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing text index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateTextIndex(columnMetadata)) continue;
            LOGGER.info("Need to create new text index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    public void updateIndices(SegmentDirectory.Writer segmentWriter) throws Exception {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._columnsToAddIdx);
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.text());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing text index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, StandardIndexes.text());
            LOGGER.info("Removed existing text index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateTextIndex(columnMetadata)) continue;
            this.createTextIndexForColumn(segmentWriter, columnMetadata);
        }
    }

    private boolean shouldCreateTextIndex(ColumnMetadata columnMetadata) {
        if (columnMetadata != null) {
            this.checkUnsupportedOperationsForTextIndex(columnMetadata);
            return true;
        }
        return false;
    }

    private void checkUnsupportedOperationsForTextIndex(ColumnMetadata columnMetadata) {
        String column = columnMetadata.getColumnName();
        if (columnMetadata.getDataType() != FieldSpec.DataType.STRING) {
            throw new UnsupportedOperationException("Text index is currently only supported on STRING columns: " + column);
        }
    }

    private void createTextIndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        String columnName = columnMetadata.getColumnName();
        int numDocs = columnMetadata.getTotalDocs();
        boolean hasDictionary = columnMetadata.hasDictionary();
        columnMetadata = this.createForwardIndexIfNeeded(segmentWriter, columnName, true);
        LOGGER.info("Creating new text index for column: {} in segment: {}, hasDictionary: {}", new Object[]{columnName, segmentName, hasDictionary});
        File segmentDirectory = SegmentDirectoryPaths.segmentDirectoryFor((File)indexDir, (SegmentVersion)this._segmentDirectory.getSegmentMetadata().getVersion());
        IndexCreationContext.Common context = IndexCreationContext.builder().withColumnMetadata(columnMetadata).withIndexDir(segmentDirectory).withTextCommitOnClose(true).build();
        TextIndexConfig config = (TextIndexConfig)((FieldIndexConfigs)this._fieldIndexConfigs.get(columnName)).getConfig(StandardIndexes.text());
        try (ForwardIndexReader<?> forwardIndexReader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             TextIndexCreator textIndexCreator = (TextIndexCreator)StandardIndexes.text().createIndexCreator((IndexCreationContext)context, (IndexConfig)config);){
            if (columnMetadata.isSingleValue()) {
                this.processSVField(segmentWriter, hasDictionary, forwardIndexReader, readerContext, textIndexCreator, numDocs, columnMetadata);
            } else {
                this.processMVField(segmentWriter, hasDictionary, forwardIndexReader, readerContext, textIndexCreator, numDocs, columnMetadata);
            }
            textIndexCreator.seal();
        }
        LOGGER.info("Created text index for column: {} in segment: {}", (Object)columnName, (Object)segmentName);
    }

    private void processSVField(SegmentDirectory.Writer segmentWriter, boolean hasDictionary, ForwardIndexReader forwardIndexReader, ForwardIndexReaderContext readerContext, TextIndexCreator textIndexCreator, int numDocs, ColumnMetadata columnMetadata) throws IOException {
        if (!hasDictionary) {
            for (int docId = 0; docId < numDocs; ++docId) {
                textIndexCreator.add(forwardIndexReader.getString(docId, readerContext));
            }
        } else {
            try (Dictionary dictionary = DictionaryIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);){
                for (int docId = 0; docId < numDocs; ++docId) {
                    int dictId = forwardIndexReader.getDictId(docId, readerContext);
                    textIndexCreator.add(dictionary.getStringValue(dictId));
                }
            }
        }
    }

    private void processMVField(SegmentDirectory.Writer segmentWriter, boolean hasDictionary, ForwardIndexReader forwardIndexReader, ForwardIndexReaderContext readerContext, TextIndexCreator textIndexCreator, int numDocs, ColumnMetadata columnMetadata) throws IOException {
        if (!hasDictionary) {
            String[] valueBuffer = new String[columnMetadata.getMaxNumberOfMultiValues()];
            for (int docId = 0; docId < numDocs; ++docId) {
                int length = forwardIndexReader.getStringMV(docId, valueBuffer, readerContext);
                textIndexCreator.add(valueBuffer, length);
            }
        } else {
            try (Dictionary dictionary = DictionaryIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);){
                int maxNumEntries = columnMetadata.getMaxNumberOfMultiValues();
                int[] dictIdBuffer = new int[maxNumEntries];
                String[] valueBuffer = new String[maxNumEntries];
                for (int docId = 0; docId < numDocs; ++docId) {
                    int length = forwardIndexReader.getDictIdMV(docId, dictIdBuffer, readerContext);
                    for (int i = 0; i < length; ++i) {
                        valueBuffer[i] = dictionary.getStringValue(dictIdBuffer[i]);
                    }
                    textIndexCreator.add(valueBuffer, length);
                }
            }
        }
    }
}

