/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.FALFInterner;

public class OnHeapBytesDictionary
extends BaseImmutableDictionary {
    private final Object2IntOpenHashMap<ByteArray> _valToDictId;
    private final ByteArray[] _dictIdToVal;

    public OnHeapBytesDictionary(PinotDataBuffer dataBuffer, int length, int numBytesPerValue, @Nullable FALFInterner<byte[]> byteInterner) {
        super(dataBuffer, length, numBytesPerValue);
        this._valToDictId = new Object2IntOpenHashMap(length);
        this._valToDictId.defaultReturnValue(-1);
        this._dictIdToVal = new ByteArray[length];
        for (int dictId = 0; dictId < length; ++dictId) {
            ByteArray value;
            this._dictIdToVal[dictId] = value = new ByteArray(this.getBytes(dictId), byteInterner);
            this._valToDictId.put((Object)value, dictId);
        }
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.BYTES;
    }

    @Override
    public int indexOf(String stringValue) {
        return this._valToDictId.getInt((Object)BytesUtils.toByteArray((String)stringValue));
    }

    public int indexOf(ByteArray bytesValue) {
        return this._valToDictId.getInt((Object)bytesValue);
    }

    public int insertionIndexOf(String stringValue) {
        ByteArray byteArray = BytesUtils.toByteArray((String)stringValue);
        int index = this._valToDictId.getInt((Object)byteArray);
        return index != -1 ? index : Arrays.binarySearch(this._dictIdToVal, byteArray);
    }

    public byte[] get(int dictId) {
        return this._dictIdToVal[dictId].getBytes();
    }

    public Object getInternal(int dictId) {
        return this._dictIdToVal[dictId];
    }

    public int getIntValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public long getLongValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public float getFloatValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public double getDoubleValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimalUtils.deserialize((byte[])this._dictIdToVal[dictId].getBytes());
    }

    public String getStringValue(int dictId) {
        return BytesUtils.toHexString((byte[])this._dictIdToVal[dictId].getBytes());
    }

    public byte[] getBytesValue(int dictId) {
        return this._dictIdToVal[dictId].getBytes();
    }
}

