/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import it.unimi.dsi.fastutil.doubles.Double2IntOpenHashMap;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class OnHeapDoubleDictionary
extends BaseImmutableDictionary {
    private final Double2IntOpenHashMap _valToDictId;
    private final double[] _dictIdToVal;

    public OnHeapDoubleDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 8);
        this._valToDictId = new Double2IntOpenHashMap(length);
        this._valToDictId.defaultReturnValue(-1);
        this._dictIdToVal = new double[length];
        for (int dictId = 0; dictId < length; ++dictId) {
            double value;
            this._dictIdToVal[dictId] = value = this.getDouble(dictId);
            this._valToDictId.put(value, dictId);
        }
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.DOUBLE;
    }

    @Override
    public int indexOf(String stringValue) {
        return this._valToDictId.get(Double.parseDouble(stringValue));
    }

    public int indexOf(double doubleValue) {
        return this._valToDictId.get(doubleValue);
    }

    public int insertionIndexOf(String stringValue) {
        double doubleValue = Double.parseDouble(stringValue);
        int index = this._valToDictId.get(doubleValue);
        return index != -1 ? index : Arrays.binarySearch(this._dictIdToVal, doubleValue);
    }

    public Double get(int dictId) {
        return this._dictIdToVal[dictId];
    }

    public int getIntValue(int dictId) {
        return (int)this._dictIdToVal[dictId];
    }

    public long getLongValue(int dictId) {
        return (long)this._dictIdToVal[dictId];
    }

    public float getFloatValue(int dictId) {
        return (float)this._dictIdToVal[dictId];
    }

    public double getDoubleValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimal.valueOf(this._dictIdToVal[dictId]);
    }

    public String getStringValue(int dictId) {
        return Double.toString(this._dictIdToVal[dictId]);
    }
}

