/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import java.util.List;
import org.apache.pinot.segment.local.io.reader.impl.FixedBitIntReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public final class FixedBitSVForwardIndexReaderV2
implements ForwardIndexReader<ForwardIndexReaderContext> {
    private final FixedBitIntReader _reader;
    private final int _numDocs;
    private final int _numBitsPerValue;

    public FixedBitSVForwardIndexReaderV2(PinotDataBuffer dataBuffer, int numDocs, int numBitsPerValue) {
        this._reader = FixedBitIntReader.getReader(dataBuffer, numBitsPerValue);
        this._numDocs = numDocs;
        this._numBitsPerValue = numBitsPerValue;
    }

    public boolean isDictionaryEncoded() {
        return true;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getStoredType() {
        return FieldSpec.DataType.INT;
    }

    public int getDictId(int docId, ForwardIndexReaderContext context) {
        return this._reader.read(docId);
    }

    public void readDictIds(int[] docIds, int length, int[] dictIdBuffer, ForwardIndexReaderContext context) {
        block6: {
            int index;
            int lastDocId;
            block5: {
                int firstDocId = docIds[0];
                lastDocId = docIds[length - 1];
                index = 0;
                if (lastDocId - firstDocId + 1 == length && length >= 64) {
                    int i;
                    int bulkStartIndex = firstDocId + 31 & 0xFFFFFFE0;
                    int bulkEndIndex = lastDocId & 0xFFFFFFE0;
                    for (i = firstDocId; i < bulkStartIndex; ++i) {
                        dictIdBuffer[index++] = this._reader.readUnchecked(i);
                    }
                    for (i = bulkStartIndex; i < bulkEndIndex; i += 32) {
                        this._reader.read32(i, dictIdBuffer, index);
                        index += 32;
                    }
                }
                if (lastDocId >= this._numDocs - 2) break block5;
                for (int i = index; i < length; ++i) {
                    dictIdBuffer[i] = this._reader.readUnchecked(docIds[i]);
                }
                break block6;
            }
            dictIdBuffer[length - 1] = this._reader.read(lastDocId);
            int uncheckedEndIndex = length - 2;
            if (uncheckedEndIndex < index) break block6;
            dictIdBuffer[uncheckedEndIndex] = this._reader.read(docIds[uncheckedEndIndex]);
            for (int i = index; i < uncheckedEndIndex; ++i) {
                dictIdBuffer[i] = this._reader.readUnchecked(docIds[i]);
            }
        }
    }

    public void close() {
    }

    public boolean isBufferByteRangeInfoSupported() {
        return true;
    }

    public void recordDocIdByteRanges(int docId, ForwardIndexReaderContext context, List<ForwardIndexReader.ByteRange> ranges) {
        throw new UnsupportedOperationException("Forward index is fixed length type");
    }

    public boolean isFixedOffsetMappingType() {
        return true;
    }

    public long getRawDataStartOffset() {
        return 0L;
    }

    public int getDocLength() {
        return this._numBitsPerValue;
    }

    public boolean isDocLengthInBits() {
        return true;
    }
}

