/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.segment.local.io.compression.ChunkCompressorFactory;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkDecompressor;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.CleanerUtil;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VarByteChunkForwardIndexReaderV4
implements ForwardIndexReader<ReaderContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VarByteChunkForwardIndexReaderV4.class);
    private static final int METADATA_ENTRY_SIZE = 8;
    private final FieldSpec.DataType _storedType;
    private final int _targetDecompressedChunkSize;
    private final ChunkDecompressor _chunkDecompressor;
    private final ChunkCompressionType _chunkCompressionType;
    private final PinotDataBuffer _metadata;
    private final PinotDataBuffer _chunks;
    private final boolean _isSingleValue;
    private final long _chunksStartOffset;

    public VarByteChunkForwardIndexReaderV4(PinotDataBuffer dataBuffer, FieldSpec.DataType storedType, boolean isSingleValue) {
        int version = dataBuffer.getInt(0);
        Preconditions.checkState((version == 4 ? 1 : 0) != 0, (String)"Illegal index version: %s", (int)version);
        this._storedType = storedType;
        this._targetDecompressedChunkSize = dataBuffer.getInt(4);
        this._chunkCompressionType = ChunkCompressionType.valueOf((int)dataBuffer.getInt(8));
        this._chunkDecompressor = ChunkCompressorFactory.getDecompressor(this._chunkCompressionType);
        int chunksOffset = dataBuffer.getInt(12);
        this._metadata = dataBuffer.view(16L, (long)chunksOffset, ByteOrder.LITTLE_ENDIAN);
        this._chunksStartOffset = chunksOffset;
        this._chunks = dataBuffer.view((long)chunksOffset, dataBuffer.size(), ByteOrder.LITTLE_ENDIAN);
        this._isSingleValue = isSingleValue;
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return this._isSingleValue;
    }

    public FieldSpec.DataType getStoredType() {
        return this._storedType;
    }

    public ChunkCompressionType getCompressionType() {
        return this._chunkCompressionType == ChunkCompressionType.LZ4_LENGTH_PREFIXED ? ChunkCompressionType.LZ4 : this._chunkCompressionType;
    }

    public ReaderContext createContext() {
        return this._chunkCompressionType == ChunkCompressionType.PASS_THROUGH ? new UncompressedReaderContext(this._chunks, this._metadata, this._chunksStartOffset) : new CompressedReaderContext(this._metadata, this._chunks, this._chunksStartOffset, this._chunkDecompressor, this._chunkCompressionType, this._targetDecompressedChunkSize);
    }

    public BigDecimal getBigDecimal(int docId, ReaderContext context) {
        return BigDecimalUtils.deserialize((byte[])context.getValue(docId));
    }

    public String getString(int docId, ReaderContext context) {
        return new String(context.getValue(docId), StandardCharsets.UTF_8);
    }

    public byte[] getBytes(int docId, ReaderContext context) {
        return context.getValue(docId);
    }

    public int getIntMV(int docId, int[] valueBuffer, ReaderContext context) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(context.getValue(docId));
        int numValues = byteBuffer.getInt();
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getInt();
        }
        return numValues;
    }

    public int[] getIntMV(int docId, ReaderContext context) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(context.getValue(docId));
        int numValues = byteBuffer.getInt();
        int[] valueBuffer = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getInt();
        }
        return valueBuffer;
    }

    public int getLongMV(int docId, long[] valueBuffer, ReaderContext context) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(context.getValue(docId));
        int numValues = byteBuffer.getInt();
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getLong();
        }
        return numValues;
    }

    public long[] getLongMV(int docId, ReaderContext context) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(context.getValue(docId));
        int numValues = byteBuffer.getInt();
        long[] valueBuffer = new long[numValues];
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getLong();
        }
        return valueBuffer;
    }

    public int getFloatMV(int docId, float[] valueBuffer, ReaderContext context) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(context.getValue(docId));
        int numValues = byteBuffer.getInt();
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getFloat();
        }
        return numValues;
    }

    public float[] getFloatMV(int docId, ReaderContext context) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(context.getValue(docId));
        int numValues = byteBuffer.getInt();
        float[] valueBuffer = new float[numValues];
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getFloat();
        }
        return valueBuffer;
    }

    public int getDoubleMV(int docId, double[] valueBuffer, ReaderContext context) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(context.getValue(docId));
        int numValues = byteBuffer.getInt();
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getDouble();
        }
        return numValues;
    }

    public double[] getDoubleMV(int docId, ReaderContext context) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(context.getValue(docId));
        int numValues = byteBuffer.getInt();
        double[] valueBuffer = new double[numValues];
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getFloat();
        }
        return valueBuffer;
    }

    public int getStringMV(int docId, String[] valueBuffer, ReaderContext context) {
        byte[] bytes = context.getValue(docId);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int numValues = byteBuffer.getInt();
        int offset = (numValues + 1) * 4;
        for (int i = 0; i < numValues; ++i) {
            int length = byteBuffer.getInt((i + 1) * 4);
            valueBuffer[i] = new String(bytes, offset, length, StandardCharsets.UTF_8);
            offset += length;
        }
        return numValues;
    }

    public String[] getStringMV(int docId, ReaderContext context) {
        byte[] bytes = context.getValue(docId);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int numValues = byteBuffer.getInt();
        int offset = (numValues + 1) * 4;
        String[] valueBuffer = new String[numValues];
        for (int i = 0; i < numValues; ++i) {
            int length = byteBuffer.getInt((i + 1) * 4);
            valueBuffer[i] = new String(bytes, offset, length, StandardCharsets.UTF_8);
            offset += length;
        }
        return valueBuffer;
    }

    public int getBytesMV(int docId, byte[][] valueBuffer, ReaderContext context) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(context.getValue(docId));
        int numValues = byteBuffer.getInt();
        byteBuffer.position((numValues + 1) * 4);
        for (int i = 0; i < numValues; ++i) {
            int length = byteBuffer.getInt((i + 1) * 4);
            byte[] bytes = new byte[length];
            byteBuffer.get(bytes, 0, length);
            valueBuffer[i] = bytes;
        }
        return numValues;
    }

    public byte[][] getBytesMV(int docId, ReaderContext context) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(context.getValue(docId));
        int numValues = byteBuffer.getInt();
        byteBuffer.position((numValues + 1) * 4);
        byte[][] valueBuffer = new byte[numValues][];
        for (int i = 0; i < numValues; ++i) {
            int length = byteBuffer.getInt((i + 1) * 4);
            byte[] bytes = new byte[length];
            byteBuffer.get(bytes, 0, length);
            valueBuffer[i] = bytes;
        }
        return valueBuffer;
    }

    public void close() throws IOException {
        this._chunkDecompressor.close();
    }

    public boolean isBufferByteRangeInfoSupported() {
        return true;
    }

    public void recordDocIdByteRanges(int docId, ReaderContext context, List<ForwardIndexReader.ByteRange> ranges) {
        context.recordRangesForDocId(docId, ranges);
    }

    public boolean isFixedOffsetMappingType() {
        return false;
    }

    public long getRawDataStartOffset() {
        throw new UnsupportedOperationException("Forward index is not fixed length type");
    }

    public int getDocLength() {
        throw new UnsupportedOperationException("Forward index is not fixed length type");
    }

    private static final class CompressedReaderContext
    extends ReaderContext {
        private final ByteBuffer _decompressedBuffer;
        private final ChunkDecompressor _chunkDecompressor;
        private final ChunkCompressionType _chunkCompressionType;

        CompressedReaderContext(PinotDataBuffer metadata, PinotDataBuffer chunks, long chunkStartOffset, ChunkDecompressor chunkDecompressor, ChunkCompressionType chunkCompressionType, int targetChunkSize) {
            super(metadata, chunks, chunkStartOffset);
            this._chunkDecompressor = chunkDecompressor;
            this._chunkCompressionType = chunkCompressionType;
            this._decompressedBuffer = ByteBuffer.allocateDirect(targetChunkSize).order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        protected byte[] processChunkAndReadFirstValue(int docId, long offset, long limit) throws IOException {
            this._decompressedBuffer.clear();
            ByteBuffer compressed = this._chunks.toDirectByteBuffer(offset, (int)(limit - offset));
            if (this._regularChunk) {
                this._chunkDecompressor.decompress(compressed, this._decompressedBuffer);
                this._numDocsInCurrentChunk = this._decompressedBuffer.getInt(0);
                return this.readSmallUncompressedValue(docId);
            }
            return this.readHugeCompressedValue(compressed, this._chunkDecompressor.decompressedLength(compressed));
        }

        @Override
        protected byte[] readSmallUncompressedValue(int docId) {
            int index = docId - this._docIdOffset;
            int offset = this._decompressedBuffer.getInt((index + 1) * 4);
            int nextOffset = index == this._numDocsInCurrentChunk - 1 ? this._decompressedBuffer.limit() : this._decompressedBuffer.getInt((index + 2) * 4);
            byte[] bytes = new byte[nextOffset - offset];
            this._decompressedBuffer.position(offset);
            this._decompressedBuffer.get(bytes);
            this._decompressedBuffer.position(0);
            return bytes;
        }

        private byte[] readHugeCompressedValue(ByteBuffer compressed, int decompressedLength) throws IOException {
            byte[] value = new byte[decompressedLength];
            if (this._chunkCompressionType == ChunkCompressionType.SNAPPY || this._chunkCompressionType == ChunkCompressionType.ZSTANDARD) {
                this.decompressViaDirectBuffer(compressed, value);
            } else {
                this._chunkDecompressor.decompress(compressed, ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN));
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decompressViaDirectBuffer(ByteBuffer compressed, byte[] target) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocateDirect(target.length).order(ByteOrder.LITTLE_ENDIAN);
            try {
                this._chunkDecompressor.decompress(compressed, buffer);
                buffer.get(target);
            }
            finally {
                if (CleanerUtil.UNMAP_SUPPORTED) {
                    CleanerUtil.getCleaner().freeBuffer(buffer);
                }
            }
        }

        public void close() {
            CleanerUtil.cleanQuietly((ByteBuffer)this._decompressedBuffer);
        }
    }

    private static final class UncompressedReaderContext
    extends ReaderContext {
        private ByteBuffer _chunk;
        private List<ForwardIndexReader.ByteRange> _ranges;

        UncompressedReaderContext(PinotDataBuffer metadata, PinotDataBuffer chunks, long chunkStartOffset) {
            super(chunks, metadata, chunkStartOffset);
        }

        @Override
        protected byte[] processChunkAndReadFirstValue(int docId, long offset, long limit) {
            this._chunk = this._chunks.toDirectByteBuffer(offset, (int)(limit - offset));
            if (!this._regularChunk) {
                return this.readHugeValue();
            }
            this._numDocsInCurrentChunk = this._chunk.getInt(0);
            return this.readSmallUncompressedValue(docId);
        }

        private byte[] readHugeValue() {
            byte[] value = new byte[this._chunk.capacity()];
            this._chunk.get(value);
            return value;
        }

        @Override
        protected byte[] readSmallUncompressedValue(int docId) {
            int index = docId - this._docIdOffset;
            int offset = this._chunk.getInt((index + 1) * 4);
            int nextOffset = index == this._numDocsInCurrentChunk - 1 ? this._chunk.limit() : this._chunk.getInt((index + 2) * 4);
            byte[] bytes = new byte[nextOffset - offset];
            this._chunk.position(offset);
            this._chunk.get(bytes);
            this._chunk.position(0);
            return bytes;
        }

        public void close() {
        }
    }

    public static abstract class ReaderContext
    implements ForwardIndexReaderContext {
        protected final PinotDataBuffer _chunks;
        protected final PinotDataBuffer _metadata;
        protected int _docIdOffset;
        protected int _nextDocIdOffset;
        protected boolean _regularChunk;
        protected int _numDocsInCurrentChunk;
        protected long _chunkStartOffset;
        private List<ForwardIndexReader.ByteRange> _ranges;

        protected ReaderContext(PinotDataBuffer metadata, PinotDataBuffer chunks, long chunkStartOffset) {
            this._chunks = chunks;
            this._metadata = metadata;
            this._chunkStartOffset = chunkStartOffset;
        }

        private void recordRangesForDocId(int docId, List<ForwardIndexReader.ByteRange> ranges) {
            if (docId >= this._docIdOffset && docId < this._nextDocIdOffset) {
                ranges.addAll(this._ranges);
            } else {
                this.initAndRecordRangesForDocId(docId, ranges);
            }
        }

        public byte[] getValue(int docId) {
            if (docId >= this._docIdOffset && docId < this._nextDocIdOffset) {
                return this.readSmallUncompressedValue(docId);
            }
            try {
                return this.decompressAndRead(docId);
            }
            catch (IOException e) {
                LOGGER.error("Exception caught while decompressing data chunk", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        protected long chunkIndexFor(int docId) {
            long low = 0L;
            long high = this._metadata.size() / 8L - 1L;
            while (low <= high) {
                long mid = low + high >>> 1;
                long position = mid * 8L;
                int midDocId = this._metadata.getInt(position) & Integer.MAX_VALUE;
                if (midDocId < docId) {
                    low = mid + 1L;
                    continue;
                }
                if (midDocId > docId) {
                    high = mid - 1L;
                    continue;
                }
                return position;
            }
            return (low - 1L) * 8L;
        }

        protected abstract byte[] processChunkAndReadFirstValue(int var1, long var2, long var4) throws IOException;

        protected abstract byte[] readSmallUncompressedValue(int var1);

        private byte[] decompressAndRead(int docId) throws IOException {
            long limit;
            long metadataEntry = this.chunkIndexFor(docId);
            int info = this._metadata.getInt(metadataEntry);
            this._docIdOffset = info & Integer.MAX_VALUE;
            this._regularChunk = this._docIdOffset == info;
            long offset = (long)this._metadata.getInt(metadataEntry + 4L) & 0xFFFFFFFFL;
            if (this._metadata.size() - 8L > metadataEntry) {
                this._nextDocIdOffset = this._metadata.getInt(metadataEntry + 8L) & Integer.MAX_VALUE;
                limit = (long)this._metadata.getInt(metadataEntry + 8L + 4L) & 0xFFFFFFFFL;
            } else {
                this._nextDocIdOffset = Integer.MAX_VALUE;
                limit = this._chunks.size();
            }
            return this.processChunkAndReadFirstValue(docId, offset, limit);
        }

        private void initAndRecordRangesForDocId(int docId, List<ForwardIndexReader.ByteRange> ranges) {
            long limit;
            this._ranges = new ArrayList<ForwardIndexReader.ByteRange>();
            this._ranges.add(new ForwardIndexReader.ByteRange(0L, (int)this._metadata.size()));
            long metadataEntry = this.chunkIndexFor(docId);
            int info = this._metadata.getInt(metadataEntry);
            this._docIdOffset = info & Integer.MAX_VALUE;
            this._regularChunk = this._docIdOffset == info;
            long offset = (long)this._metadata.getInt(metadataEntry + 4L) & 0xFFFFFFFFL;
            if (this._metadata.size() - 8L > metadataEntry) {
                this._nextDocIdOffset = this._metadata.getInt(metadataEntry + 8L) & Integer.MAX_VALUE;
                limit = (long)this._metadata.getInt(metadataEntry + 8L + 4L) & 0xFFFFFFFFL;
            } else {
                this._nextDocIdOffset = Integer.MAX_VALUE;
                limit = this._chunks.size();
            }
            this._ranges.add(new ForwardIndexReader.ByteRange(this._chunkStartOffset + offset, (int)(limit - offset)));
            ranges.addAll(this._ranges);
        }
    }
}

