/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.vector;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.pinot.segment.local.segment.index.readers.vector.HnswDocIdCollector;
import org.apache.pinot.segment.spi.index.creator.VectorIndexConfig;
import org.apache.pinot.segment.spi.index.reader.VectorIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HnswVectorIndexReader
implements VectorIndexReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HnswVectorIndexReader.class);
    private final IndexReader _indexReader;
    private final Directory _indexDirectory;
    private final IndexSearcher _indexSearcher;
    private final String _column;
    private final DocIdTranslator _docIdTranslator;
    private boolean _useANDForMultiTermQueries = false;

    public HnswVectorIndexReader(String column, File indexDir, int numDocs, VectorIndexConfig config) {
        this._column = column;
        try {
            File indexFile = this.getVectorIndexFile(indexDir);
            this._indexDirectory = FSDirectory.open((Path)indexFile.toPath());
            this._indexReader = DirectoryReader.open((Directory)this._indexDirectory);
            this._indexSearcher = new IndexSearcher(this._indexReader);
            this._docIdTranslator = new DocIdTranslator(indexDir, this._column, numDocs, this._indexSearcher);
        }
        catch (Exception e) {
            LOGGER.error("Failed to instantiate Lucene HNSW index reader for column {}, exception {}", (Object)column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private File getVectorIndexFile(File segmentIndexDir) {
        File file = SegmentDirectoryPaths.findVectorIndexIndexFile((File)segmentIndexDir, (String)this._column);
        if (file == null) {
            throw new IllegalStateException("Failed to find HNSW index file for column: " + this._column);
        }
        return file;
    }

    public MutableRoaringBitmap getDocIds(float[] searchQuery, int topK) {
        MutableRoaringBitmap docIds = new MutableRoaringBitmap();
        HnswDocIdCollector docIDCollector = new HnswDocIdCollector(docIds, this._docIdTranslator);
        try {
            QueryParser parser = new QueryParser(this._column, null);
            if (this._useANDForMultiTermQueries) {
                parser.setDefaultOperator(QueryParser.Operator.AND);
            }
            KnnFloatVectorQuery knnFloatVectorQuery = new KnnFloatVectorQuery(this._column, searchQuery, topK);
            this._indexSearcher.search((Query)knnFloatVectorQuery, (Collector)docIDCollector);
            return docIds;
        }
        catch (Exception e) {
            String msg = "Caught exception while searching the HNSW index for column:" + this._column + ", search query:" + searchQuery;
            throw new RuntimeException(msg, e);
        }
    }

    public void close() throws IOException {
        this._indexReader.close();
        this._indexDirectory.close();
        this._docIdTranslator.close();
    }

    static class DocIdTranslator
    implements Closeable {
        final PinotDataBuffer _buffer;

        DocIdTranslator(File segmentIndexDir, String column, int numDocs, IndexSearcher indexSearcher) throws Exception {
            int length = 4 * numDocs;
            File docIdMappingFile = new File(SegmentDirectoryPaths.findSegmentDirectory((File)segmentIndexDir), column + ".vector.hnsw.mapping");
            String desc = "Vector index docId mapping buffer: " + column;
            if (docIdMappingFile.exists()) {
                this._buffer = PinotDataBuffer.mapFile((File)docIdMappingFile, (boolean)true, (long)0L, (long)length, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (String)desc);
            } else {
                this._buffer = PinotDataBuffer.mapFile((File)docIdMappingFile, (boolean)false, (long)0L, (long)length, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (String)desc);
                for (int i = 0; i < numDocs; ++i) {
                    try {
                        Document document = indexSearcher.doc(i);
                        int pinotDocId = Integer.parseInt(document.get("DocID"));
                        this._buffer.putInt(i * 4, pinotDocId);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Caught exception while building doc id mapping for HNSW index column: " + column, e);
                    }
                }
            }
        }

        int getPinotDocId(int luceneDocId) {
            return this._buffer.getInt(luceneDocId * 4);
        }

        @Override
        public void close() throws IOException {
            this._buffer.close();
        }
    }
}

