/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.readers.sort;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.local.segment.readers.sort.SegmentSorter;

public class PinotSegmentSorter
implements SegmentSorter {
    private final int _numDocs;
    private final Map<String, PinotSegmentColumnReader> _columnReaderMap;

    public PinotSegmentSorter(int numDocs, Map<String, PinotSegmentColumnReader> columnReaderMap) {
        this._numDocs = numDocs;
        this._columnReaderMap = columnReaderMap;
    }

    @Override
    public int[] getSortedDocIds(List<String> sortOrder) {
        int numSortedColumns = sortOrder.size();
        PinotSegmentColumnReader[] sortedColumnReaders = new PinotSegmentColumnReader[numSortedColumns];
        for (int i3 = 0; i3 < numSortedColumns; ++i3) {
            String sortedColumn = sortOrder.get(i3);
            PinotSegmentColumnReader sortedColumnReader = this._columnReaderMap.get(sortedColumn);
            Preconditions.checkState((sortedColumnReader != null ? 1 : 0) != 0, (String)"Failed to find sorted column: %s", (Object)sortedColumn);
            Preconditions.checkState((boolean)sortedColumnReader.isSingleValue(), (String)"Unsupported sorted multi-value column: %s", (Object)sortedColumn);
            Preconditions.checkState((boolean)sortedColumnReader.hasDictionary(), (String)"Unsupported sorted no-dictionary column: %s", (Object)sortedColumn);
            sortedColumnReaders[i3] = sortedColumnReader;
        }
        int[] sortedDocIds = new int[this._numDocs];
        for (int i4 = 0; i4 < this._numDocs; ++i4) {
            sortedDocIds[i4] = i4;
        }
        Arrays.quickSort((int)0, (int)this._numDocs, (i1, i2) -> {
            int docId1 = sortedDocIds[i1];
            int docId2 = sortedDocIds[i2];
            for (PinotSegmentColumnReader sortedColumnReader : sortedColumnReaders) {
                int result = sortedColumnReader.getDictionary().compare(sortedColumnReader.getDictId(docId1), sortedColumnReader.getDictId(docId2));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }, (i, j) -> {
            int temp = sortedDocIds[i];
            sortedDocIds[i] = sortedDocIds[j];
            sortedDocIds[j] = temp;
        });
        return sortedDocIds;
    }
}

