/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.builder;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.Configuration;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.local.aggregator.ValueAggregatorFactory;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueFixedByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueUnsortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueVarByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.local.startree.StarTreeBuilderUtils;
import org.apache.pinot.segment.local.startree.v2.builder.SingleTreeBuilder;
import org.apache.pinot.segment.local.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.AggregationSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseSingleTreeBuilder
implements SingleTreeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSingleTreeBuilder.class);
    final StarTreeV2BuilderConfig _builderConfig;
    final File _outputDir;
    final ImmutableSegment _segment;
    final Configuration _metadataProperties;
    final int _numDimensions;
    final String[] _dimensionsSplitOrder;
    final Set<Integer> _skipStarNodeCreationForDimensions;
    final PinotSegmentColumnReader[] _dimensionReaders;
    final int _numMetrics;
    final String[] _metrics;
    final ValueAggregator[] _valueAggregators;
    final PinotSegmentColumnReader[] _metricReaders;
    final AggregationSpec[] _aggregationSpecs;
    final int _maxLeafRecords;
    final StarTreeBuilderUtils.TreeNode _rootNode = this.getNewNode();
    int _numDocs;
    int _numNodes;

    BaseSingleTreeBuilder(StarTreeV2BuilderConfig builderConfig, File outputDir, ImmutableSegment segment, Configuration metadataProperties) {
        this._builderConfig = builderConfig;
        this._outputDir = outputDir;
        this._segment = segment;
        this._metadataProperties = metadataProperties;
        List<String> dimensionsSplitOrder = builderConfig.getDimensionsSplitOrder();
        this._numDimensions = dimensionsSplitOrder.size();
        this._dimensionsSplitOrder = new String[this._numDimensions];
        this._skipStarNodeCreationForDimensions = new HashSet<Integer>();
        this._dimensionReaders = new PinotSegmentColumnReader[this._numDimensions];
        Set<String> skipStarNodeCreationForDimensions = builderConfig.getSkipStarNodeCreationForDimensions();
        for (int i = 0; i < this._numDimensions; ++i) {
            String dimension;
            this._dimensionsSplitOrder[i] = dimension = dimensionsSplitOrder.get(i);
            if (skipStarNodeCreationForDimensions.contains(dimension)) {
                this._skipStarNodeCreationForDimensions.add(i);
            }
            this._dimensionReaders[i] = new PinotSegmentColumnReader((IndexSegment)segment, dimension);
            Preconditions.checkState((boolean)this._dimensionReaders[i].hasDictionary(), (Object)("Dimension: " + dimension + " does not have dictionary"));
        }
        TreeMap<AggregationFunctionColumnPair, AggregationSpec> aggregationSpecs = builderConfig.getAggregationSpecs();
        this._numMetrics = aggregationSpecs.size();
        this._metrics = new String[this._numMetrics];
        this._valueAggregators = new ValueAggregator[this._numMetrics];
        this._metricReaders = new PinotSegmentColumnReader[this._numMetrics];
        this._aggregationSpecs = new AggregationSpec[this._numMetrics];
        int index = 0;
        for (Map.Entry<AggregationFunctionColumnPair, AggregationSpec> entry : aggregationSpecs.entrySet()) {
            AggregationFunctionColumnPair functionColumnPair = entry.getKey();
            this._metrics[index] = functionColumnPair.toColumnName();
            this._valueAggregators[index] = ValueAggregatorFactory.getValueAggregator(functionColumnPair.getFunctionType(), Collections.emptyList());
            this._aggregationSpecs[index] = entry.getValue();
            if (this._valueAggregators[index].getAggregationType() != AggregationFunctionType.COUNT) {
                String column = functionColumnPair.getColumn();
                this._metricReaders[index] = new PinotSegmentColumnReader((IndexSegment)segment, column);
            }
            ++index;
        }
        this._maxLeafRecords = builderConfig.getMaxLeafRecords();
    }

    abstract void appendRecord(Record var1) throws IOException;

    abstract Record getStarTreeRecord(int var1) throws IOException;

    abstract int getDimensionValue(int var1, int var2) throws IOException;

    abstract Iterator<Record> sortAndAggregateSegmentRecords(int var1) throws IOException;

    abstract Iterator<Record> generateRecordsForStarNode(int var1, int var2, int var3) throws IOException;

    int[] getSegmentRecordDimensions(int docId) {
        int[] dimensions = new int[this._numDimensions];
        for (int i = 0; i < this._numDimensions; ++i) {
            dimensions[i] = this._dimensionReaders[i].getDictId(docId);
        }
        return dimensions;
    }

    Record getSegmentRecord(int docId) {
        int[] dimensions = this.getSegmentRecordDimensions(docId);
        Object[] metrics = new Object[this._numMetrics];
        for (int i = 0; i < this._numMetrics; ++i) {
            if (this._metricReaders[i] == null) continue;
            metrics[i] = this._metricReaders[i].getValue(docId);
        }
        return new Record(dimensions, metrics);
    }

    Record mergeSegmentRecord(@Nullable Record aggregatedRecord, Record segmentRecord) {
        if (aggregatedRecord == null) {
            int[] dimensions = Arrays.copyOf(segmentRecord._dimensions, this._numDimensions);
            Object[] metrics = new Object[this._numMetrics];
            for (int i = 0; i < this._numMetrics; ++i) {
                metrics[i] = this._valueAggregators[i].getInitialAggregatedValue(segmentRecord._metrics[i]);
            }
            return new Record(dimensions, metrics);
        }
        for (int i = 0; i < this._numMetrics; ++i) {
            aggregatedRecord._metrics[i] = this._valueAggregators[i].applyRawValue(aggregatedRecord._metrics[i], segmentRecord._metrics[i]);
        }
        return aggregatedRecord;
    }

    Record mergeStarTreeRecord(@Nullable Record aggregatedRecord, Record starTreeRecord) {
        if (aggregatedRecord == null) {
            int[] dimensions = Arrays.copyOf(starTreeRecord._dimensions, this._numDimensions);
            Object[] metrics = new Object[this._numMetrics];
            for (int i = 0; i < this._numMetrics; ++i) {
                metrics[i] = this._valueAggregators[i].cloneAggregatedValue(starTreeRecord._metrics[i]);
            }
            return new Record(dimensions, metrics);
        }
        for (int i = 0; i < this._numMetrics; ++i) {
            aggregatedRecord._metrics[i] = this._valueAggregators[i].applyAggregatedValue(aggregatedRecord._metrics[i], starTreeRecord._metrics[i]);
        }
        return aggregatedRecord;
    }

    @Override
    public void build() throws Exception {
        long startTime = System.currentTimeMillis();
        LOGGER.info("Starting building star-tree with config: {}", (Object)this._builderConfig);
        int numSegmentRecords = this._segment.getSegmentMetadata().getTotalDocs();
        Iterator<Record> recordIterator = this.sortAndAggregateSegmentRecords(numSegmentRecords);
        while (recordIterator.hasNext()) {
            this.appendToStarTree(recordIterator.next());
        }
        int numStarTreeRecords = this._numDocs;
        LOGGER.info("Generated {} star-tree records from {} segment records", (Object)numStarTreeRecords, (Object)numSegmentRecords);
        this.constructStarTree(this._rootNode, 0, this._numDocs);
        int numRecordsUnderStarNode = this._numDocs - numStarTreeRecords;
        LOGGER.info("Finished constructing star-tree, got {} tree nodes and {} records under star-node", (Object)this._numNodes, (Object)numRecordsUnderStarNode);
        this.createAggregatedDocs(this._rootNode);
        int numAggregatedRecords = this._numDocs - numStarTreeRecords - numRecordsUnderStarNode;
        LOGGER.info("Finished creating aggregated documents, got {} aggregated records", (Object)numAggregatedRecords);
        this.createForwardIndexes();
        StarTreeBuilderUtils.serializeTree(new File(this._outputDir, "star_tree.index"), this._rootNode, this._dimensionsSplitOrder, this._numNodes);
        this._builderConfig.writeMetadata(this._metadataProperties, this._numDocs);
        LOGGER.info("Finished building star-tree in {}ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void appendToStarTree(Record record) throws IOException {
        this.appendRecord(record);
        ++this._numDocs;
    }

    private StarTreeBuilderUtils.TreeNode getNewNode() {
        ++this._numNodes;
        return new StarTreeBuilderUtils.TreeNode();
    }

    private void constructStarTree(StarTreeBuilderUtils.TreeNode node, int startDocId, int endDocId) throws IOException {
        int childDimensionId = node._dimensionId + 1;
        if (childDimensionId == this._numDimensions) {
            return;
        }
        node._childDimensionId = childDimensionId;
        Map<Integer, StarTreeBuilderUtils.TreeNode> children = this.constructNonStarNodes(startDocId, endDocId, childDimensionId);
        node._children = children;
        if (!this._skipStarNodeCreationForDimensions.contains(childDimensionId) && children.size() > 1) {
            children.put(-1, this.constructStarNode(startDocId, endDocId, childDimensionId));
        }
        for (StarTreeBuilderUtils.TreeNode child : children.values()) {
            if (child._endDocId - child._startDocId <= this._maxLeafRecords) continue;
            this.constructStarTree(child, child._startDocId, child._endDocId);
        }
    }

    private Map<Integer, StarTreeBuilderUtils.TreeNode> constructNonStarNodes(int startDocId, int endDocId, int dimensionId) throws IOException {
        HashMap<Integer, StarTreeBuilderUtils.TreeNode> nodes = new HashMap<Integer, StarTreeBuilderUtils.TreeNode>();
        int nodeStartDocId = startDocId;
        int nodeDimensionValue = this.getDimensionValue(startDocId, dimensionId);
        for (int i = startDocId + 1; i < endDocId; ++i) {
            int dimensionValue = this.getDimensionValue(i, dimensionId);
            if (dimensionValue == nodeDimensionValue) continue;
            StarTreeBuilderUtils.TreeNode child = this.getNewNode();
            child._dimensionId = dimensionId;
            child._dimensionValue = nodeDimensionValue;
            child._startDocId = nodeStartDocId;
            child._endDocId = i;
            nodes.put(nodeDimensionValue, child);
            nodeStartDocId = i;
            nodeDimensionValue = dimensionValue;
        }
        StarTreeBuilderUtils.TreeNode lastNode = this.getNewNode();
        lastNode._dimensionId = dimensionId;
        lastNode._dimensionValue = nodeDimensionValue;
        lastNode._startDocId = nodeStartDocId;
        lastNode._endDocId = endDocId;
        nodes.put(nodeDimensionValue, lastNode);
        return nodes;
    }

    private StarTreeBuilderUtils.TreeNode constructStarNode(int startDocId, int endDocId, int dimensionId) throws IOException {
        StarTreeBuilderUtils.TreeNode starNode = this.getNewNode();
        starNode._dimensionId = dimensionId;
        starNode._dimensionValue = -1;
        starNode._startDocId = this._numDocs;
        Iterator<Record> recordIterator = this.generateRecordsForStarNode(startDocId, endDocId, dimensionId);
        while (recordIterator.hasNext()) {
            this.appendToStarTree(recordIterator.next());
        }
        starNode._endDocId = this._numDocs;
        return starNode;
    }

    private Record createAggregatedDocs(StarTreeBuilderUtils.TreeNode node) throws IOException {
        Record aggregatedRecord = null;
        if (node._children == null) {
            if (node._startDocId == node._endDocId - 1) {
                aggregatedRecord = this.getStarTreeRecord(node._startDocId);
                node._aggregatedDocId = node._startDocId;
            } else {
                int i;
                for (i = node._startDocId; i < node._endDocId; ++i) {
                    aggregatedRecord = this.mergeStarTreeRecord(aggregatedRecord, this.getStarTreeRecord(i));
                }
                assert (aggregatedRecord != null);
                for (i = node._dimensionId + 1; i < this._numDimensions; ++i) {
                    aggregatedRecord._dimensions[i] = 0;
                }
                node._aggregatedDocId = this._numDocs;
                this.appendToStarTree(aggregatedRecord);
            }
        } else if (node._children.containsKey(-1)) {
            for (StarTreeBuilderUtils.TreeNode child : node._children.values()) {
                if (child._dimensionValue == -1) {
                    aggregatedRecord = this.createAggregatedDocs(child);
                    node._aggregatedDocId = child._aggregatedDocId;
                    continue;
                }
                this.createAggregatedDocs(child);
            }
        } else {
            for (StarTreeBuilderUtils.TreeNode child : node._children.values()) {
                aggregatedRecord = this.mergeStarTreeRecord(aggregatedRecord, this.createAggregatedDocs(child));
            }
            assert (aggregatedRecord != null);
            for (int i = node._dimensionId + 1; i < this._numDimensions; ++i) {
                aggregatedRecord._dimensions[i] = 0;
            }
            node._aggregatedDocId = this._numDocs;
            this.appendToStarTree(aggregatedRecord);
        }
        return aggregatedRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createForwardIndexes() throws Exception {
        SingleValueUnsortedForwardIndexCreator[] dimensionIndexCreators = new SingleValueUnsortedForwardIndexCreator[this._numDimensions];
        for (int i = 0; i < this._numDimensions; ++i) {
            String dimension = this._dimensionsSplitOrder[i];
            int cardinality = this._segment.getDictionary(dimension).length();
            dimensionIndexCreators[i] = new SingleValueUnsortedForwardIndexCreator(this._outputDir, this._dimensionsSplitOrder[i], cardinality, this._numDocs);
        }
        ForwardIndexCreator[] metricIndexCreators = new ForwardIndexCreator[this._numMetrics];
        for (int i = 0; i < this._numMetrics; ++i) {
            String metric = this._metrics[i];
            ValueAggregator valueAggregator = this._valueAggregators[i];
            FieldSpec.DataType dataType = valueAggregator.getAggregatedValueType();
            AggregationSpec aggregationSpec = this._aggregationSpecs[i];
            ChunkCompressionType compressionType = ChunkCompressionType.valueOf((String)aggregationSpec.getCompressionCodec().name());
            metricIndexCreators[i] = dataType == FieldSpec.DataType.BYTES ? new SingleValueVarByteRawIndexCreator(this._outputDir, compressionType, metric, this._numDocs, FieldSpec.DataType.BYTES, valueAggregator.getMaxAggregatedValueByteSize(), aggregationSpec.isDeriveNumDocsPerChunk(), aggregationSpec.getIndexVersion(), aggregationSpec.getTargetMaxChunkSizeBytes(), aggregationSpec.getTargetDocsPerChunk()) : new SingleValueFixedByteRawIndexCreator(this._outputDir, compressionType, metric, this._numDocs, dataType, aggregationSpec.getIndexVersion(), aggregationSpec.getTargetDocsPerChunk());
        }
        try {
            for (int docId = 0; docId < this._numDocs; ++docId) {
                int i;
                Record record = this.getStarTreeRecord(docId);
                for (i = 0; i < this._numDimensions; ++i) {
                    dimensionIndexCreators[i].putDictId(record._dimensions[i]);
                }
                block14: for (i = 0; i < this._numMetrics; ++i) {
                    ValueAggregator valueAggregator = this._valueAggregators[i];
                    ForwardIndexCreator metricIndexCreator = metricIndexCreators[i];
                    switch (valueAggregator.getAggregatedValueType()) {
                        case INT: {
                            metricIndexCreator.putInt(((Integer)record._metrics[i]).intValue());
                            continue block14;
                        }
                        case LONG: {
                            metricIndexCreator.putLong(((Long)record._metrics[i]).longValue());
                            continue block14;
                        }
                        case FLOAT: {
                            metricIndexCreator.putFloat(((Float)record._metrics[i]).floatValue());
                            continue block14;
                        }
                        case DOUBLE: {
                            metricIndexCreator.putDouble(((Double)record._metrics[i]).doubleValue());
                            continue block14;
                        }
                        case BYTES: {
                            metricIndexCreator.putBytes(valueAggregator.serializeAggregatedValue(record._metrics[i]));
                            continue block14;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            }
        }
        finally {
            for (SingleValueUnsortedForwardIndexCreator singleValueUnsortedForwardIndexCreator : dimensionIndexCreators) {
                singleValueUnsortedForwardIndexCreator.close();
            }
            for (SingleValueUnsortedForwardIndexCreator singleValueUnsortedForwardIndexCreator : metricIndexCreators) {
                singleValueUnsortedForwardIndexCreator.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (PinotSegmentColumnReader dimensionReader : this._dimensionReaders) {
            dimensionReader.close();
        }
        for (PinotSegmentColumnReader metricReader : this._metricReaders) {
            if (metricReader == null) continue;
            metricReader.close();
        }
    }

    static class Record {
        final int[] _dimensions;
        final Object[] _metrics;

        Record(int[] dimensions, Object[] metrics) {
            this._dimensions = dimensions;
            this._metrics = metrics;
        }
    }
}

