/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.builder;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.startree.v2.builder.BaseSingleTreeBuilder;
import org.apache.pinot.segment.local.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class OffHeapSingleTreeBuilder
extends BaseSingleTreeBuilder {
    private static final String SEGMENT_RECORD_FILE_NAME = "segment.record";
    private static final String STAR_TREE_RECORD_FILE_NAME = "star-tree.record";
    private static final long MMAP_SIZE_THRESHOLD = 500000000L;
    private final File _segmentRecordFile;
    private final File _starTreeRecordFile;
    private final BufferedOutputStream _starTreeRecordOutputStream;
    private final List<Long> _starTreeRecordOffsets;
    private PinotDataBuffer _starTreeRecordBuffer;
    private int _numReadableStarTreeRecords;

    public OffHeapSingleTreeBuilder(StarTreeV2BuilderConfig builderConfig, File outputDir, ImmutableSegment segment, Configuration metadataProperties) throws FileNotFoundException {
        super(builderConfig, outputDir, segment, metadataProperties);
        this._segmentRecordFile = new File(this._outputDir, SEGMENT_RECORD_FILE_NAME);
        Preconditions.checkState((!this._segmentRecordFile.exists() ? 1 : 0) != 0, (Object)("Segment record file: " + this._segmentRecordFile + " already exists"));
        this._starTreeRecordFile = new File(this._outputDir, STAR_TREE_RECORD_FILE_NAME);
        Preconditions.checkState((!this._starTreeRecordFile.exists() ? 1 : 0) != 0, (Object)("Star-tree record file: " + this._starTreeRecordFile + " already exists"));
        this._starTreeRecordOutputStream = new BufferedOutputStream(new FileOutputStream(this._starTreeRecordFile));
        this._starTreeRecordOffsets = new ArrayList<Long>();
        this._starTreeRecordOffsets.add(0L);
    }

    private byte[] serializeStarTreeRecord(BaseSingleTreeBuilder.Record starTreeRecord) {
        int numBytes = this._numDimensions * 4;
        byte[][] metricBytes = new byte[this._numMetrics][];
        block10: for (int i = 0; i < this._numMetrics; ++i) {
            switch (this._valueAggregators[i].getAggregatedValueType()) {
                case LONG: {
                    numBytes += 8;
                    continue block10;
                }
                case DOUBLE: {
                    numBytes += 8;
                    continue block10;
                }
                case BYTES: {
                    metricBytes[i] = this._valueAggregators[i].serializeAggregatedValue(starTreeRecord._metrics[i]);
                    numBytes += 4 + metricBytes[i].length;
                    continue block10;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        byte[] bytes = new byte[numBytes];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(PinotDataBuffer.NATIVE_ORDER);
        for (int dimension : starTreeRecord._dimensions) {
            byteBuffer.putInt(dimension);
        }
        block12: for (int i = 0; i < this._numMetrics; ++i) {
            switch (this._valueAggregators[i].getAggregatedValueType()) {
                case LONG: {
                    byteBuffer.putLong((Long)starTreeRecord._metrics[i]);
                    continue block12;
                }
                case DOUBLE: {
                    byteBuffer.putDouble((Double)starTreeRecord._metrics[i]);
                    continue block12;
                }
                case BYTES: {
                    byteBuffer.putInt(metricBytes[i].length);
                    byteBuffer.put(metricBytes[i]);
                    continue block12;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return bytes;
    }

    private BaseSingleTreeBuilder.Record deserializeStarTreeRecord(PinotDataBuffer buffer, long offset) {
        int[] dimensions = new int[this._numDimensions];
        for (int i = 0; i < this._numDimensions; ++i) {
            dimensions[i] = buffer.getInt(offset);
            offset += 4L;
        }
        Object[] metrics = new Object[this._numMetrics];
        block6: for (int i = 0; i < this._numMetrics; ++i) {
            switch (this._valueAggregators[i].getAggregatedValueType()) {
                case LONG: {
                    metrics[i] = buffer.getLong(offset);
                    offset += 8L;
                    continue block6;
                }
                case DOUBLE: {
                    metrics[i] = buffer.getDouble(offset);
                    offset += 8L;
                    continue block6;
                }
                case BYTES: {
                    int numBytes = buffer.getInt(offset);
                    byte[] bytes = new byte[numBytes];
                    buffer.copyTo(offset += 4L, bytes);
                    offset += (long)numBytes;
                    metrics[i] = this._valueAggregators[i].deserializeAggregatedValue(bytes);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return new BaseSingleTreeBuilder.Record(dimensions, metrics);
    }

    @Override
    void appendRecord(BaseSingleTreeBuilder.Record record) throws IOException {
        byte[] bytes = this.serializeStarTreeRecord(record);
        this._starTreeRecordOutputStream.write(bytes);
        this._starTreeRecordOffsets.add(this._starTreeRecordOffsets.get(this._numDocs) + (long)bytes.length);
    }

    @Override
    BaseSingleTreeBuilder.Record getStarTreeRecord(int docId) throws IOException {
        this.ensureBufferReadable(docId);
        return this.deserializeStarTreeRecord(this._starTreeRecordBuffer, this._starTreeRecordOffsets.get(docId));
    }

    @Override
    int getDimensionValue(int docId, int dimensionId) throws IOException {
        this.ensureBufferReadable(docId);
        return this._starTreeRecordBuffer.getInt(this._starTreeRecordOffsets.get(docId) + (long)(dimensionId * 4));
    }

    private void ensureBufferReadable(int docId) throws IOException {
        if (this._numReadableStarTreeRecords <= docId) {
            this._starTreeRecordOutputStream.flush();
            if (this._starTreeRecordBuffer != null) {
                this._starTreeRecordBuffer.close();
            }
            this._starTreeRecordBuffer = PinotDataBuffer.mapFile((File)this._starTreeRecordFile, (boolean)true, (long)0L, (long)this._starTreeRecordOffsets.get(this._numDocs), (ByteOrder)PinotDataBuffer.NATIVE_ORDER, (String)"OffHeapSingleTreeBuilder: star-tree record buffer");
            this._numReadableStarTreeRecords = this._numDocs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Iterator<BaseSingleTreeBuilder.Record> sortAndAggregateSegmentRecords(final int numDocs) throws IOException {
        long bufferSize = (long)numDocs * (long)this._numDimensions * 4L;
        PinotDataBuffer dataBuffer = bufferSize > 500000000L ? PinotDataBuffer.mapFile((File)this._segmentRecordFile, (boolean)false, (long)0L, (long)bufferSize, (ByteOrder)PinotDataBuffer.NATIVE_ORDER, (String)"OffHeapSingleTreeBuilder: segment record buffer") : PinotDataBuffer.allocateDirect((long)bufferSize, (ByteOrder)PinotDataBuffer.NATIVE_ORDER, (String)"OffHeapSingleTreeBuilder: segment record buffer");
        final int[] sortedDocIds = new int[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            sortedDocIds[i] = i;
        }
        try {
            long offset = 0L;
            for (int i = 0; i < numDocs; ++i) {
                int[] dimensions = this.getSegmentRecordDimensions(i);
                for (int j = 0; j < this._numDimensions; ++j) {
                    dataBuffer.putInt(offset, dimensions[j]);
                    offset += 4L;
                }
            }
            it.unimi.dsi.fastutil.Arrays.quickSort((int)0, (int)numDocs, (i1, i2) -> {
                long offset1 = (long)sortedDocIds[i1] * (long)this._numDimensions * 4L;
                long offset2 = (long)sortedDocIds[i2] * (long)this._numDimensions * 4L;
                for (int i = 0; i < this._numDimensions; ++i) {
                    int dimension2;
                    int dimension1 = dataBuffer.getInt(offset1 + (long)(i * 4));
                    if (dimension1 == (dimension2 = dataBuffer.getInt(offset2 + (long)(i * 4)))) continue;
                    return dimension1 - dimension2;
                }
                return 0;
            }, (i1, i2) -> {
                int temp = sortedDocIds[i1];
                sortedDocIds[i1] = sortedDocIds[i2];
                sortedDocIds[i2] = temp;
            });
        }
        finally {
            dataBuffer.close();
            if (this._segmentRecordFile.exists()) {
                FileUtils.forceDelete((File)this._segmentRecordFile);
            }
        }
        return new Iterator<BaseSingleTreeBuilder.Record>(){
            boolean _hasNext = true;
            BaseSingleTreeBuilder.Record _currentRecord = OffHeapSingleTreeBuilder.this.getSegmentRecord(sortedDocIds[0]);
            int _docId = 1;

            @Override
            public boolean hasNext() {
                return this._hasNext;
            }

            @Override
            public BaseSingleTreeBuilder.Record next() {
                BaseSingleTreeBuilder.Record next = OffHeapSingleTreeBuilder.this.mergeSegmentRecord(null, this._currentRecord);
                while (this._docId < numDocs) {
                    BaseSingleTreeBuilder.Record record = OffHeapSingleTreeBuilder.this.getSegmentRecord(sortedDocIds[this._docId++]);
                    if (!Arrays.equals(record._dimensions, next._dimensions)) {
                        this._currentRecord = record;
                        return next;
                    }
                    next = OffHeapSingleTreeBuilder.this.mergeSegmentRecord(next, record);
                }
                this._hasNext = false;
                return next;
            }
        };
    }

    @Override
    Iterator<BaseSingleTreeBuilder.Record> generateRecordsForStarNode(int startDocId, int endDocId, final int dimensionId) throws IOException {
        this.ensureBufferReadable(endDocId);
        final int numDocs = endDocId - startDocId;
        final int[] sortedDocIds = new int[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            sortedDocIds[i] = startDocId + i;
        }
        it.unimi.dsi.fastutil.Arrays.quickSort((int)0, (int)numDocs, (i1, i2) -> {
            long offset1 = this._starTreeRecordOffsets.get(sortedDocIds[i1]);
            long offset2 = this._starTreeRecordOffsets.get(sortedDocIds[i2]);
            for (int i = dimensionId + 1; i < this._numDimensions; ++i) {
                int dimension2;
                int dimension1 = this._starTreeRecordBuffer.getInt(offset1 + (long)(i * 4));
                if (dimension1 == (dimension2 = this._starTreeRecordBuffer.getInt(offset2 + (long)(i * 4)))) continue;
                return dimension1 - dimension2;
            }
            return 0;
        }, (i1, i2) -> {
            int temp = sortedDocIds[i1];
            sortedDocIds[i1] = sortedDocIds[i2];
            sortedDocIds[i2] = temp;
        });
        return new Iterator<BaseSingleTreeBuilder.Record>(){
            boolean _hasNext = true;
            BaseSingleTreeBuilder.Record _currentRecord = OffHeapSingleTreeBuilder.this.getStarTreeRecord(sortedDocIds[0]);
            int _docId = 1;

            private boolean hasSameDimensions(BaseSingleTreeBuilder.Record record1, BaseSingleTreeBuilder.Record record2) {
                for (int i = dimensionId + 1; i < OffHeapSingleTreeBuilder.this._numDimensions; ++i) {
                    if (record1._dimensions[i] == record2._dimensions[i]) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this._hasNext;
            }

            @Override
            public BaseSingleTreeBuilder.Record next() {
                BaseSingleTreeBuilder.Record next = OffHeapSingleTreeBuilder.this.mergeStarTreeRecord(null, this._currentRecord);
                next._dimensions[dimensionId] = 0;
                while (this._docId < numDocs) {
                    BaseSingleTreeBuilder.Record record;
                    try {
                        record = OffHeapSingleTreeBuilder.this.getStarTreeRecord(sortedDocIds[this._docId++]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (!this.hasSameDimensions(record, this._currentRecord)) {
                        this._currentRecord = record;
                        return next;
                    }
                    next = OffHeapSingleTreeBuilder.this.mergeStarTreeRecord(next, record);
                }
                this._hasNext = false;
                return next;
            }
        };
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._starTreeRecordBuffer.close();
        this._starTreeRecordOutputStream.close();
        FileUtils.forceDelete((File)this._starTreeRecordFile);
    }
}

