/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.builder;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.utils.FileUtils;
import org.apache.pinot.segment.local.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeIndexMapUtils;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;

public class StarTreeIndexCombiner
implements Closeable {
    private final FileChannel _fileChannel;

    public StarTreeIndexCombiner(File indexFile) throws IOException {
        Preconditions.checkState((!indexFile.exists() ? 1 : 0) != 0, (Object)"Star-tree index file already exists");
        this._fileChannel = new RandomAccessFile(indexFile, "rw").getChannel();
    }

    public List<Pair<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>> combine(StarTreeV2BuilderConfig builderConfig, File starTreeIndexDir) throws IOException {
        ArrayList<Pair<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>> indexMap = new ArrayList<Pair<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>>();
        File starTreeIndexFile = new File(starTreeIndexDir, "star_tree.index");
        indexMap.add(Pair.of((Object)StarTreeIndexMapUtils.STAR_TREE_INDEX_KEY, (Object)this.writeFile(starTreeIndexFile)));
        for (String dimension : builderConfig.getDimensionsSplitOrder()) {
            File dimensionIndexFile = new File(starTreeIndexDir, dimension + ".sv.unsorted.fwd");
            indexMap.add((Pair<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>)Pair.of((Object)new StarTreeIndexMapUtils.IndexKey(StarTreeIndexMapUtils.IndexType.FORWARD_INDEX, dimension), (Object)this.writeFile(dimensionIndexFile)));
        }
        for (AggregationFunctionColumnPair functionColumnPair : builderConfig.getFunctionColumnPairs()) {
            String metric = functionColumnPair.toColumnName();
            File metricIndexFile = new File(starTreeIndexDir, metric + ".sv.raw.fwd");
            indexMap.add((Pair<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>)Pair.of((Object)new StarTreeIndexMapUtils.IndexKey(StarTreeIndexMapUtils.IndexType.FORWARD_INDEX, metric), (Object)this.writeFile(metricIndexFile)));
        }
        org.apache.commons.io.FileUtils.cleanDirectory((File)starTreeIndexDir);
        return indexMap;
    }

    private StarTreeIndexMapUtils.IndexValue writeFile(File srcFile) throws IOException {
        try (FileChannel src = new RandomAccessFile(srcFile, "r").getChannel();){
            long offset = this._fileChannel.position();
            long size = src.size();
            FileUtils.transferBytes((FileChannel)src, (long)0L, (long)size, (FileChannel)this._fileChannel);
            StarTreeIndexMapUtils.IndexValue indexValue = new StarTreeIndexMapUtils.IndexValue(offset, size);
            return indexValue;
        }
    }

    @Override
    public void close() throws IOException {
        this._fileChannel.close();
    }
}

