/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

public class ComparisonColumns
implements Comparable<ComparisonColumns> {
    private final Comparable[] _values;
    private final int _comparableIndex;
    public static final int SEALED_SEGMENT_COMPARISON_INDEX = -1;

    public ComparisonColumns(Comparable[] values, int comparableIndex) {
        this._values = values;
        this._comparableIndex = comparableIndex;
    }

    public Comparable[] getValues() {
        return this._values;
    }

    public int getComparableIndex() {
        return this._comparableIndex;
    }

    public int compareToSealed(ComparisonColumns other) {
        for (int i = 0; i < this._values.length; ++i) {
            Comparable comparisonValue = this._values[i];
            Comparable otherComparisonValue = other.getValues()[i];
            if (comparisonValue == null && otherComparisonValue == null) continue;
            if (comparisonValue == null) {
                return -1;
            }
            if (otherComparisonValue == null) {
                return 1;
            }
            int comparisonResult = comparisonValue.compareTo(otherComparisonValue);
            if (comparisonResult == 0) continue;
            return comparisonResult;
        }
        return 0;
    }

    @Override
    public int compareTo(ComparisonColumns other) {
        if (this._comparableIndex == -1) {
            return this.compareToSealed(other);
        }
        Comparable comparisonValue = this._values[this._comparableIndex];
        Comparable otherComparisonValue = other.getValues()[this._comparableIndex];
        int comparisonResult = otherComparisonValue == null ? 1 : comparisonValue.compareTo(otherComparisonValue);
        if (comparisonResult >= 0) {
            for (int i = 0; i < this._values.length; ++i) {
                if (i == this._comparableIndex) continue;
                this._values[i] = other._values[i];
            }
        }
        return comparisonResult;
    }
}

