/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.segment.local.upsert.BaseTableUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.ConcurrentMapPartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.UpsertUtils;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.spi.config.table.UpsertConfig;

@ThreadSafe
public class ConcurrentMapTableUpsertMetadataManager
extends BaseTableUpsertMetadataManager {
    private final Map<Integer, ConcurrentMapPartitionUpsertMetadataManager> _partitionMetadataManagerMap = new ConcurrentHashMap<Integer, ConcurrentMapPartitionUpsertMetadataManager>();

    @Override
    public ConcurrentMapPartitionUpsertMetadataManager getOrCreatePartitionManager(int partitionId) {
        return this._partitionMetadataManagerMap.computeIfAbsent(partitionId, k -> new ConcurrentMapPartitionUpsertMetadataManager(this._tableNameWithType, (int)k, this._context));
    }

    @Override
    public void stop() {
        for (ConcurrentMapPartitionUpsertMetadataManager metadataManager : this._partitionMetadataManagerMap.values()) {
            metadataManager.stop();
        }
    }

    @Override
    public Map<Integer, Long> getPartitionToPrimaryKeyCount() {
        HashMap<Integer, Long> partitionToPrimaryKeyCount = new HashMap<Integer, Long>();
        this._partitionMetadataManagerMap.forEach((partitionID, upsertMetadataManager) -> partitionToPrimaryKeyCount.put((Integer)partitionID, upsertMetadataManager.getNumPrimaryKeys()));
        return partitionToPrimaryKeyCount;
    }

    @Override
    public void setSegmentContexts(List<SegmentContext> segmentContexts, Map<String, String> queryOptions) {
        if (this._consistencyMode != UpsertConfig.ConsistencyMode.NONE && !QueryOptionsUtils.isSkipUpsertView(queryOptions)) {
            this._partitionMetadataManagerMap.forEach((partitionID, upsertMetadataManager) -> upsertMetadataManager.setSegmentContexts(segmentContexts, queryOptions));
        }
        for (SegmentContext segmentContext : segmentContexts) {
            if (segmentContext.getQueryableDocIdsSnapshot() != null) continue;
            IndexSegment segment = segmentContext.getIndexSegment();
            segmentContext.setQueryableDocIdsSnapshot(UpsertUtils.getQueryableDocIdsSnapshotFromSegment(segment));
        }
    }

    @Override
    public void close() throws IOException {
        for (ConcurrentMapPartitionUpsertMetadataManager metadataManager : this._partitionMetadataManagerMap.values()) {
            metadataManager.close();
        }
    }
}

