/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.local.upsert.ConcurrentMapTableUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.TableUpsertMetadataManager;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableUpsertMetadataManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableUpsertMetadataManagerFactory.class);
    public static final String UPSERT_DEFAULT_METADATA_MANAGER_CLASS = "default.metadata.manager.class";
    public static final String UPSERT_DEFAULT_ENABLE_SNAPSHOT = "default.enable.snapshot";
    public static final String UPSERT_DEFAULT_ENABLE_PRELOAD = "default.enable.preload";
    public static final String UPSERT_DEFAULT_ALLOW_PARTIAL_UPSERT_CONSUMPTION_DURING_COMMIT = "default.allow.partial.upsert.consumption.during.commit";

    private TableUpsertMetadataManagerFactory() {
    }

    public static TableUpsertMetadataManager create(TableConfig tableConfig, @Nullable PinotConfiguration instanceUpsertConfig) {
        TableUpsertMetadataManager metadataManager;
        String tableNameWithType = tableConfig.getTableName();
        UpsertConfig upsertConfig = tableConfig.getUpsertConfig();
        Preconditions.checkArgument((upsertConfig != null ? 1 : 0) != 0, (String)"Must provide upsert config for table: %s", (Object)tableNameWithType);
        String metadataManagerClass = upsertConfig.getMetadataManagerClass();
        if (instanceUpsertConfig != null) {
            if (metadataManagerClass == null) {
                metadataManagerClass = instanceUpsertConfig.getProperty(UPSERT_DEFAULT_METADATA_MANAGER_CLASS);
            }
            if (!upsertConfig.isEnableSnapshot()) {
                upsertConfig.setEnableSnapshot(Boolean.parseBoolean(instanceUpsertConfig.getProperty(UPSERT_DEFAULT_ENABLE_SNAPSHOT, "false")));
            }
            if (!upsertConfig.isEnablePreload()) {
                upsertConfig.setEnablePreload(Boolean.parseBoolean(instanceUpsertConfig.getProperty(UPSERT_DEFAULT_ENABLE_PRELOAD, "false")));
            }
            if (!upsertConfig.isAllowPartialUpsertConsumptionDuringCommit()) {
                upsertConfig.setAllowPartialUpsertConsumptionDuringCommit(Boolean.parseBoolean(instanceUpsertConfig.getProperty(UPSERT_DEFAULT_ALLOW_PARTIAL_UPSERT_CONSUMPTION_DURING_COMMIT, "false")));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)metadataManagerClass)) {
            LOGGER.info("Creating TableUpsertMetadataManager with class: {} for table: {}", (Object)metadataManagerClass, (Object)tableNameWithType);
            try {
                metadataManager = (TableUpsertMetadataManager)Class.forName(metadataManagerClass).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Caught exception while constructing TableUpsertMetadataManager with class: %s for table: %s", metadataManagerClass, tableNameWithType), e);
            }
        } else {
            LOGGER.info("Creating ConcurrentMapTableUpsertMetadataManager for table: {}", (Object)tableNameWithType);
            metadataManager = new ConcurrentMapTableUpsertMetadataManager();
        }
        return metadataManager;
    }
}

