/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.upsert.PartialUpsertHandler;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.Schema;

public class UpsertContext {
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private final List<String> _primaryKeyColumns;
    private final List<String> _comparisonColumns;
    private final String _deleteRecordColumn;
    private final HashFunction _hashFunction;
    private final PartialUpsertHandler _partialUpsertHandler;
    private final boolean _enableSnapshot;
    private final boolean _enablePreload;
    private final double _metadataTTL;
    private final double _deletedKeysTTL;
    private final UpsertConfig.ConsistencyMode _consistencyMode;
    private final long _upsertViewRefreshIntervalMs;
    private final File _tableIndexDir;
    private final TableDataManager _tableDataManager;

    private UpsertContext(TableConfig tableConfig, Schema schema, List<String> primaryKeyColumns, List<String> comparisonColumns, @Nullable String deleteRecordColumn, HashFunction hashFunction, @Nullable PartialUpsertHandler partialUpsertHandler, boolean enableSnapshot, boolean enablePreload, double metadataTTL, double deletedKeysTTL, UpsertConfig.ConsistencyMode consistencyMode, long upsertViewRefreshIntervalMs, File tableIndexDir, @Nullable TableDataManager tableDataManager) {
        this._tableConfig = tableConfig;
        this._schema = schema;
        this._primaryKeyColumns = primaryKeyColumns;
        this._comparisonColumns = comparisonColumns;
        this._deleteRecordColumn = deleteRecordColumn;
        this._hashFunction = hashFunction;
        this._partialUpsertHandler = partialUpsertHandler;
        this._enableSnapshot = enableSnapshot;
        this._enablePreload = enablePreload;
        this._metadataTTL = metadataTTL;
        this._deletedKeysTTL = deletedKeysTTL;
        this._consistencyMode = consistencyMode;
        this._upsertViewRefreshIntervalMs = upsertViewRefreshIntervalMs;
        this._tableIndexDir = tableIndexDir;
        this._tableDataManager = tableDataManager;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public List<String> getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    public List<String> getComparisonColumns() {
        return this._comparisonColumns;
    }

    public String getDeleteRecordColumn() {
        return this._deleteRecordColumn;
    }

    public HashFunction getHashFunction() {
        return this._hashFunction;
    }

    public PartialUpsertHandler getPartialUpsertHandler() {
        return this._partialUpsertHandler;
    }

    public boolean isSnapshotEnabled() {
        return this._enableSnapshot;
    }

    public boolean isPreloadEnabled() {
        return this._enablePreload;
    }

    public double getMetadataTTL() {
        return this._metadataTTL;
    }

    public double getDeletedKeysTTL() {
        return this._deletedKeysTTL;
    }

    public UpsertConfig.ConsistencyMode getConsistencyMode() {
        return this._consistencyMode;
    }

    public long getUpsertViewRefreshIntervalMs() {
        return this._upsertViewRefreshIntervalMs;
    }

    public File getTableIndexDir() {
        return this._tableIndexDir;
    }

    public TableDataManager getTableDataManager() {
        return this._tableDataManager;
    }

    public static class Builder {
        private TableConfig _tableConfig;
        private Schema _schema;
        private List<String> _primaryKeyColumns;
        private List<String> _comparisonColumns;
        private String _deleteRecordColumn;
        private HashFunction _hashFunction = HashFunction.NONE;
        private PartialUpsertHandler _partialUpsertHandler;
        private boolean _enableSnapshot;
        private boolean _enablePreload;
        private double _metadataTTL;
        private double _deletedKeysTTL;
        private UpsertConfig.ConsistencyMode _consistencyMode;
        private long _upsertViewRefreshIntervalMs;
        private File _tableIndexDir;
        private TableDataManager _tableDataManager;

        public Builder setTableConfig(TableConfig tableConfig) {
            this._tableConfig = tableConfig;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this._schema = schema;
            return this;
        }

        public Builder setPrimaryKeyColumns(List<String> primaryKeyColumns) {
            this._primaryKeyColumns = primaryKeyColumns;
            return this;
        }

        public Builder setComparisonColumns(List<String> comparisonColumns) {
            this._comparisonColumns = comparisonColumns;
            return this;
        }

        public Builder setDeleteRecordColumn(String deleteRecordColumn) {
            this._deleteRecordColumn = deleteRecordColumn;
            return this;
        }

        public Builder setHashFunction(HashFunction hashFunction) {
            this._hashFunction = hashFunction;
            return this;
        }

        public Builder setPartialUpsertHandler(PartialUpsertHandler partialUpsertHandler) {
            this._partialUpsertHandler = partialUpsertHandler;
            return this;
        }

        public Builder setEnableSnapshot(boolean enableSnapshot) {
            this._enableSnapshot = enableSnapshot;
            return this;
        }

        public Builder setEnablePreload(boolean enablePreload) {
            this._enablePreload = enablePreload;
            return this;
        }

        public Builder setMetadataTTL(double metadataTTL) {
            this._metadataTTL = metadataTTL;
            return this;
        }

        public Builder setDeletedKeysTTL(double deletedKeysTTL) {
            this._deletedKeysTTL = deletedKeysTTL;
            return this;
        }

        public Builder setConsistencyMode(UpsertConfig.ConsistencyMode consistencyMode) {
            this._consistencyMode = consistencyMode;
            return this;
        }

        public Builder setUpsertViewRefreshIntervalMs(long upsertViewRefreshIntervalMs) {
            this._upsertViewRefreshIntervalMs = upsertViewRefreshIntervalMs;
            return this;
        }

        public Builder setTableIndexDir(File tableIndexDir) {
            this._tableIndexDir = tableIndexDir;
            return this;
        }

        public Builder setTableDataManager(TableDataManager tableDataManager) {
            this._tableDataManager = tableDataManager;
            return this;
        }

        public UpsertContext build() {
            Preconditions.checkState((this._tableConfig != null ? 1 : 0) != 0, (Object)"Table config must be set");
            Preconditions.checkState((this._schema != null ? 1 : 0) != 0, (Object)"Schema must be set");
            Preconditions.checkState((boolean)CollectionUtils.isNotEmpty(this._primaryKeyColumns), (Object)"Primary key columns must be set");
            Preconditions.checkState((boolean)CollectionUtils.isNotEmpty(this._comparisonColumns), (Object)"Comparison columns must be set");
            Preconditions.checkState((this._hashFunction != null ? 1 : 0) != 0, (Object)"Hash function must be set");
            Preconditions.checkState((this._tableIndexDir != null ? 1 : 0) != 0, (Object)"Table index directory must be set");
            return new UpsertContext(this._tableConfig, this._schema, this._primaryKeyColumns, this._comparisonColumns, this._deleteRecordColumn, this._hashFunction, this._partialUpsertHandler, this._enableSnapshot, this._enablePreload, this._metadataTTL, this._deletedKeysTTL, this._consistencyMode, this._upsertViewRefreshIntervalMs, this._tableIndexDir, this._tableDataManager);
        }
    }
}

