/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert.merger;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.segment.local.segment.readers.LazyRow;
import org.apache.pinot.segment.local.upsert.merger.BasePartialUpsertMerger;
import org.apache.pinot.segment.local.upsert.merger.columnar.OverwriteMerger;
import org.apache.pinot.segment.local.upsert.merger.columnar.PartialUpsertColumnMerger;
import org.apache.pinot.segment.local.upsert.merger.columnar.PartialUpsertColumnMergerFactory;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.readers.GenericRow;

public class PartialUpsertColumnarMerger
extends BasePartialUpsertMerger {
    private final PartialUpsertColumnMerger _defaultColumnValueMerger;
    private final Map<String, PartialUpsertColumnMerger> _column2Mergers = new HashMap<String, PartialUpsertColumnMerger>();

    public PartialUpsertColumnarMerger(List<String> primaryKeyColumns, List<String> comparisonColumns, UpsertConfig upsertConfig) {
        super(primaryKeyColumns, comparisonColumns, upsertConfig);
        this._defaultColumnValueMerger = PartialUpsertColumnMergerFactory.getMerger(upsertConfig.getDefaultPartialUpsertStrategy());
        Map partialUpsertStrategies = upsertConfig.getPartialUpsertStrategies();
        Preconditions.checkArgument((partialUpsertStrategies != null ? 1 : 0) != 0, (Object)"Partial upsert strategies must be configured");
        for (Map.Entry entry : partialUpsertStrategies.entrySet()) {
            this._column2Mergers.put((String)entry.getKey(), PartialUpsertColumnMergerFactory.getMerger((UpsertConfig.Strategy)entry.getValue()));
        }
    }

    @Override
    public void merge(LazyRow previousRow, GenericRow newRow, Map<String, Object> resultHolder) {
        for (String column : previousRow.getColumnNames()) {
            Object prevValue;
            if (this._primaryKeyColumns.contains(column) || this._comparisonColumns.contains(column)) continue;
            PartialUpsertColumnMerger merger = this._column2Mergers.getOrDefault(column, this._defaultColumnValueMerger);
            if (!(merger instanceof OverwriteMerger)) {
                prevValue = previousRow.getValue(column);
                if (prevValue == null) continue;
                if (newRow.isNullValue(column)) {
                    resultHolder.put(column, prevValue);
                    continue;
                }
                resultHolder.put(column, merger.merge(prevValue, newRow.getValue(column)));
                continue;
            }
            if (!newRow.isNullValue(column) || (prevValue = previousRow.getValue(column)) == null) continue;
            resultHolder.put(column, prevValue);
        }
    }
}

