/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SegmentLocks {
    private static final int DEFAULT_NUM_LOCKS = 10000;
    private final Lock[] _locks;
    private final int _numLocks;
    @Deprecated
    private static final SegmentLocks DEFAULT_LOCKS = SegmentLocks.create();

    public SegmentLocks(int numLocks) {
        this._numLocks = numLocks;
        this._locks = new Lock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this._locks[i] = new ReentrantLock();
        }
    }

    public SegmentLocks() {
        this(10000);
    }

    public Lock getLock(String tableNameWithType, String segmentName) {
        return this._locks[Math.abs((31 * tableNameWithType.hashCode() + segmentName.hashCode()) % this._numLocks)];
    }

    @Deprecated
    public static Lock getSegmentLock(String tableNameWithType, String segmentName) {
        return DEFAULT_LOCKS.getLock(tableNameWithType, segmentName);
    }

    @Deprecated
    public static SegmentLocks create() {
        return new SegmentLocks(10000);
    }

    @Deprecated
    public static SegmentLocks create(int numLocks) {
        return new SegmentLocks(numLocks);
    }
}

