/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.fst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.RegExp;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;

public class RegexpMatcher {
    private final String _regexQuery;
    private final FST<Long> _fst;
    private final Automaton _automaton;

    public RegexpMatcher(String regexQuery, FST<Long> fst) {
        this._regexQuery = regexQuery;
        this._fst = fst;
        this._automaton = new RegExp(this._regexQuery).toAutomaton();
    }

    public static List<Long> regexMatch(String regexQuery, FST<Long> fst) throws IOException {
        RegexpMatcher matcher = new RegexpMatcher(regexQuery, fst);
        return matcher.regexMatchOnFST();
    }

    public boolean match(String input) {
        CharacterRunAutomaton characterRunAutomaton = new CharacterRunAutomaton(this._automaton);
        return characterRunAutomaton.run(input);
    }

    public List<Long> regexMatchOnFST() throws IOException {
        ArrayList<Path<Long>> queue = new ArrayList<Path<Long>>();
        ArrayList<Path> endNodes = new ArrayList<Path>();
        if (this._automaton.getNumStates() == 0) {
            return Collections.emptyList();
        }
        queue.add(new Path<Long>(0, this._fst.getFirstArc(new FST.Arc()), (Long)this._fst.outputs.getNoOutput(), new IntsRefBuilder()));
        FST.Arc scratchArc = new FST.Arc();
        FST.BytesReader fstReader = this._fst.getBytesReader();
        Transition t = new Transition();
        while (!queue.isEmpty()) {
            Path path = (Path)queue.remove(queue.size() - 1);
            if (this._automaton.isAccept(path._state) && path._fstNode.isFinal()) {
                endNodes.add(path);
            }
            IntsRefBuilder currentInput = path._input;
            int count = this._automaton.initTransition(path._state, t);
            for (int i = 0; i < count; ++i) {
                IntsRefBuilder newInput;
                FST.Arc nextArc;
                this._automaton.getNextTransition(t);
                int min = t.min;
                int max = t.max;
                if (min == max) {
                    nextArc = this._fst.findTargetArc(t.min, path._fstNode, scratchArc, fstReader);
                    if (nextArc == null) continue;
                    newInput = new IntsRefBuilder();
                    newInput.copyInts(currentInput.get());
                    newInput.append(t.min);
                    queue.add(new Path<Long>(t.dest, new FST.Arc().copyFrom(nextArc), (Long)this._fst.outputs.add((Object)((Long)path._output), (Object)((Long)nextArc.output())), newInput));
                    continue;
                }
                nextArc = Util.readCeilArc((int)min, this._fst, path._fstNode, (FST.Arc)scratchArc, (FST.BytesReader)fstReader);
                while (nextArc != null && nextArc.label() <= max) {
                    newInput = new IntsRefBuilder();
                    newInput.copyInts(currentInput.get());
                    newInput.append(nextArc.label());
                    queue.add(new Path<Long>(t.dest, new FST.Arc().copyFrom(nextArc), (Long)this._fst.outputs.add((Object)((Long)path._output), (Object)((Long)nextArc.output())), newInput));
                    nextArc = nextArc.isLast() ? null : this._fst.readNextRealArc(nextArc, fstReader);
                }
            }
        }
        ArrayList<Long> matchedIds = new ArrayList<Long>();
        for (Path path : endNodes) {
            matchedIds.add((Long)path._output);
        }
        return matchedIds;
    }

    public static final class Path<T> {
        public final int _state;
        public final FST.Arc<T> _fstNode;
        public final T _output;
        public final IntsRefBuilder _input;

        public Path(int state, FST.Arc<T> fstNode, T output, IntsRefBuilder input) {
            this._state = state;
            this._fstNode = fstNode;
            this._output = output;
            this._input = input;
        }
    }
}

